/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragonmanager;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.projectiles.ProjectileSource;

public class DragonWeightManager {
    private final double DAMAGE_WEIGHT_MAX;
    public final Set<Player> players = new HashSet<Player>();
    private final Map<UUID, Double> dragonDamage = new HashMap<UUID, Double>();
    private double totalDamageDealt = 0.0;
    private final Map<UUID, Double> weightBonus = new HashMap<UUID, Double>();
    private int crystalsDestroyed = 0;
    private final WeaponMasterMain plugin;
    private final UUID currentlyActiveDragonID;
    private boolean enabled;

    public DragonWeightManager(WeaponMasterMain plugin, EnderDragon currentlyActiveDragon, double damageWeightMax) {
        this.plugin = plugin;
        this.currentlyActiveDragonID = currentlyActiveDragon.getUniqueId();
        this.enabled = true;
        this.DAMAGE_WEIGHT_MAX = damageWeightMax;
    }

    public double getDamage(UUID player) {
        return this.dragonDamage.getOrDefault(player, 0.0);
    }

    public void setDamageRaw(UUID player, double amount) {
        this.dragonDamage.put(player, amount);
    }

    public void incrementDamage(UUID player, double amount) {
        this.totalDamageDealt += amount;
        this.setDamageRaw(player, this.getDamage(player) + amount);
    }

    public double getDamageDragonWeight(UUID player) {
        double damageDealt = this.getDamage(player);
        double weightFactor = Math.min(this.DAMAGE_WEIGHT_MAX / this.totalDamageDealt, 1.0);
        return damageDealt * weightFactor;
    }

    public double getBonus(UUID player) {
        return this.weightBonus.getOrDefault(player, 0.0);
    }

    public void setBonus(UUID player, double amount) {
        this.weightBonus.put(player, amount);
    }

    public void giveBonus(UUID player, double amount) {
        this.setBonus(player, this.getBonus(player) + amount);
    }

    public int getDragonWeight(UUID player) {
        int baseWeight = (int)(this.getDamageDragonWeight(player) + this.getBonus(player));
        UUID maxPlayer = null;
        double maxAmount = 200.0;
        for (UUID p : this.dragonDamage.keySet()) {
            double d = this.getDamage(p);
            double d2 = p.equals(player) ? 30.0 : 0.0;
            double pAmount = d - d2;
            if (!(pAmount > maxAmount)) continue;
            maxAmount = pAmount;
            maxPlayer = p;
        }
        return baseWeight + (maxPlayer != null && maxPlayer.equals(player) ? 75 : 0);
    }

    public DragonWeightManager setEnabled(boolean v) {
        this.enabled = v;
        return this;
    }

    public void onDamage(EntityDamageByEntityEvent event) {
        EnderCrystal crystal;
        Player player;
        if (!this.enabled) {
            return;
        }
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
        } else if (event.getDamager() instanceof Projectile) {
            ProjectileSource shooter = ((Projectile)event.getDamager()).getShooter();
            if (!(shooter instanceof Player)) {
                return;
            }
            player = (Player)shooter;
        } else {
            return;
        }
        Entity victim = event.getEntity();
        if (victim instanceof EnderDragon && victim.getUniqueId().equals(this.currentlyActiveDragonID)) {
            if (!this.players.contains(player)) {
                this.players.add(player);
            }
            this.incrementDamage(player.getUniqueId(), event.getFinalDamage());
            this.plugin.paperUtils.sendActionBar(player, String.format("\u00a77Your damage: \u00a7c%.0f  \u00a77|  Weight: \u00a7c%d", this.getDamage(player.getUniqueId()), this.getDragonWeight(player.getUniqueId())), true);
        }
        if (victim instanceof EnderCrystal && (crystal = (EnderCrystal)victim).isShowingBottom() && this.crystalsDestroyed < 10) {
            this.giveBonus(player.getUniqueId(), 30.0);
            ++this.crystalsDestroyed;
            this.plugin.paperUtils.sendActionBar(player, String.format("\u00a77You destroyed a crystal! You have \u00a7c%.0f \u00a77bonus weight in total!", this.getBonus(player.getUniqueId())), true);
        }
    }
}

