/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.minorcrafts;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.minorcrafts.MinorItems;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.Map;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MoveOversListener
implements Listener {
    private final Random rnd = new Random();
    private final MinorItems minorItems = new MinorItems();
    private final Util util;
    private final WeaponMasterMain plugin;

    public MoveOversListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onExpertSeal(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (event.getCursor() == null || event.getCursor().getType() == Material.AIR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.util.checkFor(event.getCursor(), 0, "id: EXPERT_SEAL")) {
            return;
        }
        ItemMeta targetItem = event.getCurrentItem().getItemMeta();
        if (targetItem == null || !targetItem.hasEnchants()) {
            player.sendMessage("\u00a7cYou can't use Expert Seal on this item!");
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "expert_seal");
        if (targetItem.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) {
            player.sendMessage("\u00a7cYou can only upgrade once!");
            return;
        }
        Map enchants = targetItem.getEnchants();
        for (Enchantment enchant : enchants.keySet()) {
            targetItem.addEnchant(enchant, (Integer)enchants.get(enchant) + 1, true);
        }
        targetItem.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)1);
        event.getCurrentItem().setItemMeta(targetItem);
        event.setCancelled(true);
        player.updateInventory();
        event.setCursor(new ItemStack(Material.AIR));
        player.sendMessage("\u00a73Success!");
    }

    @EventHandler
    public void onMasterSeal(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (event.getCursor() == null || event.getCursor().getType() == Material.AIR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.util.checkFor(event.getCursor(), 0, "id: MASTER_SEAL")) {
            return;
        }
        ItemMeta targetItem = event.getCurrentItem().getItemMeta();
        if (targetItem == null || !targetItem.hasEnchants()) {
            player.sendMessage("\u00a7cYou can't use Expert Seal on this item!");
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "expert_seal");
        if (!targetItem.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) {
            player.sendMessage("\u00a7cUse an Expert Seal first!");
            return;
        }
        if ((Integer)targetItem.getPersistentDataContainer().get(key, PersistentDataType.INTEGER) == 2) {
            player.sendMessage("\u00a7cYou can only upgrade one additional time!");
            return;
        }
        Map enchants = targetItem.getEnchants();
        for (Enchantment enchant : enchants.keySet()) {
            targetItem.addEnchant(enchant, (Integer)enchants.get(enchant) + 1, true);
        }
        targetItem.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)2);
        event.getCurrentItem().setItemMeta(targetItem);
        event.setCancelled(true);
        player.updateInventory();
        event.setCursor(new ItemStack(Material.AIR));
        player.sendMessage("\u00a73Success!");
    }

    @EventHandler
    public void onGenericDye(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (event.getCursor() == null || event.getCursor().getType() == Material.AIR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.util.checkFor(event.getCursor(), 0, "id: DYE")) {
            return;
        }
        ItemMeta targetIM = event.getCurrentItem().getItemMeta();
        if (targetIM == null || !targetIM.hasDisplayName()) {
            player.sendMessage("\u00a7cGive it a name first!");
            return;
        }
        String name = targetIM.getDisplayName();
        if (name.contains("\u00a7")) {
            player.sendMessage("\u00a7cThis item already has a color! If you really want to dye it again, remove the color first.");
            return;
        }
        switch ((String)event.getCursor().getItemMeta().getLore().get(1)) {
            case "\u00a78Dark Gray Color": {
                targetIM.setDisplayName("\u00a78" + name);
                break;
            }
            case "\u00a7bAqua Color": {
                targetIM.setDisplayName("\u00a7b" + name);
                break;
            }
            case "\u00a7aGreen Color": {
                targetIM.setDisplayName("\u00a7a" + name);
                break;
            }
            case "\u00a7dLight Purple Color": {
                targetIM.setDisplayName("\u00a7d" + name);
                break;
            }
            case "\u00a79Blue Color": {
                targetIM.setDisplayName("\u00a79" + name);
                break;
            }
            case "\u00a73Dark Aqua Color": {
                targetIM.setDisplayName("\u00a73" + name);
                break;
            }
            case "\u00a76Gold Color": {
                targetIM.setDisplayName("\u00a76" + name);
                break;
            }
            case "\u00a7cRed Color": {
                targetIM.setDisplayName("\u00a7c" + name);
                break;
            }
            case "\u00a74Dark Red Color": {
                targetIM.setDisplayName("\u00a74" + name);
                break;
            }
            case "\u00a79L\u00a73e\u00a79v\u00a73i\u00a79a\u00a73t\u00a79h\u00a73a\u00a79n \u00a73C\u00a79o\u00a73l\u00a79o\u00a73r": {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < name.length(); ++i) {
                    if (i % 2 == 0) {
                        sb.append("\u00a79").append(name.charAt(i));
                        continue;
                    }
                    sb.append("\u00a73").append(name.charAt(i));
                }
                targetIM.setDisplayName(sb.toString());
                break;
            }
            case "\u00a76E\u00a7ex\u00a76p\u00a7ee\u00a76r\u00a7et \u00a76C\u00a7eo\u00a76l\u00a7eo\u00a76r": {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < name.length(); ++i) {
                    if (i % 2 == 0) {
                        sb.append("\u00a76").append(name.charAt(i));
                        continue;
                    }
                    sb.append("\u00a7e").append(name.charAt(i));
                }
                targetIM.setDisplayName(sb.toString());
                break;
            }
            case "\u00a75D\u00a7dr\u00a75a\u00a7dg\u00a75o\u00a7dn \u00a75C\u00a7do\u00a75l\u00a7do\u00a75r": {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < name.length(); ++i) {
                    if (i % 2 == 0) {
                        sb.append("\u00a75").append(name.charAt(i));
                        continue;
                    }
                    sb.append("\u00a7d").append(name.charAt(i));
                }
                targetIM.setDisplayName(sb.toString());
                break;
            }
            default: {
                throw new RuntimeException("unknown dye");
            }
        }
        event.getCurrentItem().setItemMeta(targetIM);
        event.setCancelled(true);
        player.updateInventory();
        event.setCursor(new ItemStack(Material.AIR));
        player.sendMessage("\u00a73Success!");
    }

    @EventHandler
    public void onMasterDye(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (event.getCursor() == null || event.getCursor().getType() == Material.AIR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.util.checkFor(event.getCursor(), 0, "id: MASTER_DYE")) {
            return;
        }
        ItemMeta targetIM = event.getCurrentItem().getItemMeta();
        if (targetIM == null || !targetIM.hasDisplayName()) {
            player.sendMessage("\u00a7cGive it a name first!");
            return;
        }
        String name = targetIM.getDisplayName();
        if (name.contains("\u00a7")) {
            player.sendMessage("\u00a7cThis item already has a color! If you really want to dye it again, remove the color first.");
            return;
        }
        if (!name.contains("&")) {
            player.sendMessage("\u00a7cYou should probably put some formatting codes (&) in the name first!");
            return;
        }
        String nameFixed = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        targetIM.setDisplayName(nameFixed);
        event.getCurrentItem().setItemMeta(targetIM);
        event.setCancelled(true);
        player.updateInventory();
        event.setCursor(new ItemStack(Material.AIR));
        player.sendMessage("\u00a73Success!");
    }
}

