/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.ValkyrieAxe;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ValkyrieItemListener
implements Listener {
    private final int ITEM_TOTAL_DURABILITY = 250;
    private final float FOOD_COST;
    private final double DAMAGE_FACTOR;
    private final double FIRESTORM_RADIUS;
    private final double FIRESTORM_RADIUS_SQUARED;
    private final double MAX_ANGLE_DEG;
    private final double FIRESTORM_KNOCKBACK;
    Set<UUID> affectedEntities = new HashSet<UUID>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public ValkyrieItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        new BukkitRunnable(){

            public void run() {
                ValkyrieItemListener.this.affectedEntities.clear();
            }
        }.runTaskTimer((Plugin)plugin, 1L, 1L);
        this.FOOD_COST = (float)plugin.getConfig().getDouble("valkyrieAxe.food_cost", 2.666666);
        this.DAMAGE_FACTOR = plugin.getConfig().getDouble("valkyrieAxe.damage_factor", 0.75);
        this.FIRESTORM_RADIUS = plugin.getConfig().getDouble("valkyrieAxe.firestorm_radius", 25.0);
        this.FIRESTORM_RADIUS_SQUARED = this.FIRESTORM_RADIUS * this.FIRESTORM_RADIUS;
        this.MAX_ANGLE_DEG = plugin.getConfig().getDouble("valkyrieAxe.max_angle_deg", 32.0);
        this.FIRESTORM_KNOCKBACK = plugin.getConfig().getDouble("valkyrieAxe.firestorm_knockback", 14.0);
    }

    @EventHandler
    public void onHitEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForValkyrieAxe(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.valkryieaxe.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.valkyrie.use\u00a73.");
            return;
        }
        if (this.affectedEntities.contains(event.getEntity().getUniqueId())) {
            return;
        }
        for (Entity entity : player.getNearbyEntities(3.0, 3.0, 3.0)) {
            if (!(entity instanceof LivingEntity) || entity.getUniqueId().equals(event.getEntity().getUniqueId()) || !this.affectedEntities.add(entity.getUniqueId())) continue;
            ((LivingEntity)entity).damage(event.getDamage() * this.DAMAGE_FACTOR, (Entity)player);
            player.getWorld().spawnParticle(Particle.SWEEP_ATTACK, entity.getLocation(), 3);
            player.getWorld().playSound(entity.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        final Player player = event.getPlayer();
        if (!this.util.checkForValkyrieAxe(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.valkyrieaxe.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.valkyrieaxe.use\u00a73.");
            return;
        }
        Damageable im = (Damageable)player.getInventory().getItemInMainHand().getItemMeta();
        if (player.getGameMode() != GameMode.CREATIVE) {
            if (im.getDamage() > 200) {
                player.sendMessage("\u00a7cNot enough durability!");
                return;
            }
            if (player.getFoodLevel() < 12) {
                player.sendMessage("\u00a7cNot enough hunger!");
                return;
            }
            player.setExhaustion(player.getExhaustion() + this.FOOD_COST);
            im.setDamage(im.getDamage() + 15);
        }
        player.getInventory().getItemInMainHand().setItemMeta((ItemMeta)im);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
        for (Entity entity : player.getNearbyEntities(this.FIRESTORM_RADIUS, this.FIRESTORM_RADIUS, this.FIRESTORM_RADIUS)) {
            if (!(entity instanceof LivingEntity) || entity.getLocation().distanceSquared(player.getEyeLocation()) > this.FIRESTORM_RADIUS_SQUARED) continue;
            Vector playerToEntity = entity.getLocation().subtract(player.getEyeLocation()).toVector();
            Vector playerLooking = player.getEyeLocation().getDirection();
            double angleDegrees = (double)playerLooking.angle(playerToEntity) * 180.0 / Math.PI;
            if (!(angleDegrees < this.MAX_ANGLE_DEG)) continue;
            Vector knockbackVector = playerToEntity.normalize().multiply(this.FIRESTORM_KNOCKBACK);
            this.affectedEntities.add(entity.getUniqueId());
            ((LivingEntity)entity).damage(12.0, (Entity)player);
            entity.setVelocity(knockbackVector);
        }
        new BukkitRunnable(){
            Location currentLoc;
            Vector lookingAt;
            int runsLeft;
            {
                this.currentLoc = player.getEyeLocation();
                this.lookingAt = this.currentLoc.getDirection().multiply(0.5);
                this.runsLeft = 50;
            }

            public void run() {
                if (this.runsLeft < 0) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    player.getWorld().spawnParticle(Particle.FLAME, this.currentLoc, 3, 0.0, 0.0, 0.0, 0.15);
                    this.currentLoc.add(this.lookingAt);
                }
                --this.runsLeft;
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

