/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.SniperRifle;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SniperItemListener
implements Listener {
    private final int COOLDOWN_TICKS;
    private final WeaponMasterMain plugin;
    private final Util util;

    public SniperItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.COOLDOWN_TICKS = plugin.getConfig().getInt("sniper.cooldown_ticks", 30);
    }

    private void fireOneRound(Player player) {
        Location eyeLoc = player.getEyeLocation();
        Vector velocityVector = eyeLoc.getDirection().multiply(50.95);
        Arrow arrow = (Arrow)player.getWorld().spawnEntity(eyeLoc, EntityType.ARROW);
        arrow.setDamage(13.0);
        arrow.setKnockbackStrength(3);
        arrow.setVelocity(velocityVector);
        arrow.setShooter((ProjectileSource)player);
        player.getWorld().spawnParticle(Particle.SMALL_FLAME, eyeLoc, 20);
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (this.util.checkForSniperRifle(event.getBow())) {
            ((Player)event.getEntity()).sendMessage("\u00a7cYou need to use LEFT CLICK to shoot this.");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForSniperRifle(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.sniperrifle.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.sniperrifle.use\u00a73.");
            return;
        }
        final ItemStack sniper = player.getInventory().getItemInMainHand();
        final Damageable durability = (Damageable)sniper.getItemMeta();
        if (durability.getDamage() > 1) {
            if (player.getGameMode() == GameMode.CREATIVE) {
                durability.setDamage(0);
                sniper.setItemMeta((ItemMeta)durability);
                player.sendMessage("\u00a7cFixed durability!");
            } else {
                this.plugin.paperUtils.sendActionBar(player, "\u00a7cThis weapon is reloading! This takes 1.5 seconds.", true);
                return;
            }
        }
        if (player.getGameMode() == GameMode.CREATIVE || player.getInventory().containsAtLeast(new ItemStack(Material.ARROW), 1)) {
            player.setVelocity(player.getVelocity().subtract(player.getEyeLocation().getDirection().multiply(0.06)));
            this.fireOneRound(player);
            if (player.getGameMode() != GameMode.CREATIVE) {
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.ARROW, 1)});
            }
            new BukkitRunnable(){
                int ticksLeft;
                {
                    this.ticksLeft = SniperItemListener.this.COOLDOWN_TICKS - 1;
                }

                public void run() {
                    if (this.ticksLeft == 0) {
                        durability.setDamage(0);
                        sniper.setItemMeta((ItemMeta)durability);
                        this.cancel();
                        return;
                    }
                    int remainingDurability = (int)(384.0 / (double)SniperItemListener.this.COOLDOWN_TICKS * (double)(SniperItemListener.this.COOLDOWN_TICKS - this.ticksLeft));
                    durability.setDamage(384 - remainingDurability);
                    sniper.setItemMeta((ItemMeta)durability);
                    --this.ticksLeft;
                }
            }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
        }
    }
}

