/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.ShreddedAxe;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.MathHelper;
import io.github.greatericontop.weaponmaster.utils.TrueDamageHelper;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class ShreddedListener
implements Listener {
    private final NamespacedKey pdcKeyOwner;
    private final Map<UUID, Integer> zombieCount = new HashMap<UUID, Integer>();
    private final int SURVIVAL_DURATION;
    private final double NEW_MAX_HP;
    private final int MAX_ZOMBIES;
    private final WeaponMasterMain plugin;
    private final Util util;

    public ShreddedListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.pdcKeyOwner = new NamespacedKey((Plugin)plugin, "zombie_owner");
        this.SURVIVAL_DURATION = plugin.getConfig().getInt("shreddedAxe.survival_duration", 400);
        this.NEW_MAX_HP = plugin.getConfig().getDouble("shreddedAxe.zombie_max_hp", 50.0);
        this.MAX_ZOMBIES = plugin.getConfig().getInt("shreddedAxe.max_zombies", 10);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onDeath(EntityDeathEvent event) {
        PersistentDataContainer pdc = event.getEntity().getPersistentDataContainer();
        if (pdc.has(this.pdcKeyOwner, PersistentDataType.STRING)) {
            event.getEntity().setCustomName("\u00a72Zombie");
            event.setDroppedExp(0);
            event.getDrops().clear();
        }
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        final Player player = (Player)event.getDamager();
        if (!this.util.checkForShreddedAxe(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.shreddedaxe.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.shreddedaxe.use\u00a73.");
            return;
        }
        final LivingEntity victim = (LivingEntity)event.getEntity();
        PersistentDataContainer victimPdc = event.getEntity().getPersistentDataContainer();
        String value = (String)victimPdc.get(this.pdcKeyOwner, PersistentDataType.STRING);
        if (value != null && player.getUniqueId().equals(UUID.fromString(value))) {
            player.sendMessage("\u00a77Stopped you from damaging your own zombie! If you want to do so anyway, use a different weapon.");
            event.setCancelled(true);
            return;
        }
        if (this.zombieCount.getOrDefault(player.getUniqueId(), 0) >= this.MAX_ZOMBIES) {
            return;
        }
        this.zombieCount.put(player.getUniqueId(), this.zombieCount.getOrDefault(player.getUniqueId(), 0) + 1);
        final Zombie zombie = (Zombie)player.getWorld().spawnEntity(player.getLocation(), EntityType.ZOMBIE, true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, this.SURVIVAL_DURATION * 5, 0, true));
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, this.SURVIVAL_DURATION * 5, 0, true));
        zombie.setTarget(victim);
        zombie.setCanPickupItems(false);
        zombie.setCustomName(String.format("%s\u00a77's \u00a72Zombie", player.getDisplayName()));
        zombie.setCustomNameVisible(true);
        zombie.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(64.0);
        zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.NEW_MAX_HP);
        zombie.setHealth(this.NEW_MAX_HP);
        PersistentDataContainer pdc = zombie.getPersistentDataContainer();
        pdc.set(this.pdcKeyOwner, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                ++this.ticks;
                if (zombie.isDead()) {
                    this.cancel();
                    ShreddedListener.this.zombieCount.put(player.getUniqueId(), ShreddedListener.this.zombieCount.get(player.getUniqueId()) - 1);
                    return;
                }
                double healthPercent = zombie.getHealth() / ShreddedListener.this.NEW_MAX_HP * 100.0;
                zombie.setCustomName(String.format("%s\u00a77's \u00a72Zombie \u00a77- \u00a7%s%.0f%%", player.getDisplayName(), MathHelper.getColor(healthPercent), healthPercent));
                if (zombie.getTarget() != victim) {
                    zombie.setTarget(victim);
                }
                if (this.ticks >= ShreddedListener.this.SURVIVAL_DURATION && this.ticks % 20 == 0) {
                    TrueDamageHelper.dealTrueDamage((LivingEntity)zombie, 4.0);
                    zombie.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, zombie.getLocation().add(0.0, 0.0, 1.0), 10);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

