/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.RocketStick;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class RocketItemListener
implements Listener {
    private final double KNOCKBACK_OTHER;
    private final double KNOCKBACK_SELF;
    private final double TELEPORT_DISTANCE;
    private final WeaponMasterMain plugin;
    private final Util util;

    public RocketItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.KNOCKBACK_OTHER = plugin.getConfig().getDouble("rocketStick.knockback_other", 10.0);
        this.KNOCKBACK_SELF = plugin.getConfig().getDouble("rocketStick.knockback_self", 8.3);
        this.TELEPORT_DISTANCE = plugin.getConfig().getDouble("rocketStick.teleport_distance", 6.5);
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForRocketStick(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.rocketstick.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.rocketstick.use\u00a73.");
            return;
        }
        Vector knockback = player.getEyeLocation().getDirection().multiply(this.KNOCKBACK_OTHER);
        event.getEntity().setVelocity(event.getEntity().getVelocity().add(knockback));
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForRocketStick(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.rocketstick.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.rocketstick.use\u00a73.");
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (Util.checkForInteractableBlock(event)) {
                return;
            }
            if (player.isSneaking()) {
                RayTraceResult rtxResult = player.getWorld().rayTraceBlocks(player.getEyeLocation(), player.getEyeLocation().getDirection(), this.TELEPORT_DISTANCE + 0.1, FluidCollisionMode.NEVER, true);
                if (rtxResult != null && rtxResult.getHitBlock() != null) {
                    player.sendMessage("\u00a77You can't teleport through blocks!");
                    return;
                }
                Vector tp = player.getEyeLocation().getDirection().multiply(this.TELEPORT_DISTANCE);
                player.playSound((Entity)player, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                player.teleport(player.getEyeLocation().add(tp));
            } else {
                Vector knockback = player.getEyeLocation().getDirection().multiply(this.KNOCKBACK_SELF);
                player.setVelocity(player.getVelocity().add(knockback));
            }
        }
    }
}

