/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.PoseidonTrident;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class TridentListener
implements Listener {
    private final Set<UUID> activeTridents = new HashSet<UUID>();
    private final double LIGHTNING_CHANCE;
    private final WeaponMasterMain plugin;
    private final Util util;

    public TridentListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.LIGHTNING_CHANCE = plugin.getConfig().getDouble("poseidon.lightning_chance", 0.1);
    }

    public void regTridentRunnable() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("weaponmaster.poseidontrident.use") || !TridentListener.this.util.checkForPoseidonTrident(player.getInventory().getItemInMainHand())) continue;
                    player.addPotionEffect(new PotionEffect(PotionEffectType.CONDUIT_POWER, 39, 0));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, 39, 0));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 200L, 5L);
    }

    @EventHandler
    public void tridentThrow(ProjectileLaunchEvent event) {
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity().getShooter();
        if (!this.util.checkForPoseidonTrident(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.poseidontrident.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.poseidontrident.use\u00a73.");
            return;
        }
        player.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, player.getEyeLocation().add(player.getEyeLocation().getDirection().multiply(0.9)), 15);
        this.activeTridents.add(event.getEntity().getUniqueId());
    }

    @EventHandler
    public void onProjHit(ProjectileHitEvent event) {
        if (!this.activeTridents.contains(event.getEntity().getUniqueId())) {
            return;
        }
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        if (event.getHitEntity() == null) {
            return;
        }
        this.activeTridents.remove(event.getEntity().getUniqueId());
        if (Math.random() < this.LIGHTNING_CHANCE) {
            event.getHitEntity().getWorld().spawnEntity(event.getHitEntity().getLocation(), EntityType.LIGHTNING_BOLT);
        }
    }
}

