/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.PlutoniumBlade;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PlutoniumBladeListener
implements Listener {
    private static final int MAX_DURABILITY = 2031;
    private static final int RAYS = 10000;
    private static final double STEP = 0.4;
    private static final double GOLDEN_ANGLE = 3.88322207745093;
    private final double DAMAGE;
    private final double KNOCKBACK_STRENGTH;
    private final double CRIT_MULTIPLIER;
    private final long COOLDOWN_TICKS;
    private Map<UUID, Boolean> cooldown = new HashMap<UUID, Boolean>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public PlutoniumBladeListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.DAMAGE = plugin.getConfig().getDouble("plutonium.damage", 70.0);
        this.KNOCKBACK_STRENGTH = plugin.getConfig().getDouble("plutonium.knockback_strength", 9.0);
        this.CRIT_MULTIPLIER = plugin.getConfig().getDouble("plutonium.crit_multiplier", 1.2);
        this.COOLDOWN_TICKS = plugin.getConfig().getLong("plutoniumblade.cooldown_ticks", 400L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForPlutoniumBlade(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.plutoniumblade.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.plutoniumblade.use\u00a73.");
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.CUSTOM) {
            return;
        }
        if (player.getFallDistance() > 0.01f && !player.isOnGround() && !player.isClimbing()) {
            event.setDamage(event.getDamage() * this.CRIT_MULTIPLIER);
            player.getWorld().playSound(player.getLocation(), Sound.ITEM_MACE_SMASH_GROUND_HEAVY, 1.0f, 1.0f);
        }
    }

    @EventHandler
    public void onShiftRightClickLookingDown(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        final Player player = event.getPlayer();
        ItemStack stack = player.getInventory().getItemInMainHand();
        if (!this.util.checkForPlutoniumBlade(stack)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        if (!player.hasPermission("weaponmaster.plutoniumblade.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.plutoniumblade.use\u00a73.");
            return;
        }
        if (!this.cooldown.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            player.sendMessage("\u00a7cOn cooldown!");
            return;
        }
        Vector lookDirection = player.getEyeLocation().getDirection().normalize();
        if (lookDirection.getX() * lookDirection.getX() + lookDirection.getZ() * lookDirection.getZ() > 0.0064 || lookDirection.getY() > 0.0) {
            return;
        }
        Damageable im = (Damageable)stack.getItemMeta();
        if (im.getDamage() > 1731) {
            player.sendMessage("\u00a7cYour blade is too damaged to use this ability!");
            return;
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            int durability = 1 + 99 / (1 + im.getEnchantLevel(Enchantment.UNBREAKING));
            im.setDamage(im.getDamage() + durability);
            stack.setItemMeta((ItemMeta)im);
        }
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 1.0f, 1.0f);
        new BukkitRunnable(){
            int i = 0;
            Location startLoc;
            Set<UUID> alreadyHit = new HashSet<UUID>();

            public void run() {
                ++this.i;
                if (this.i == 1) {
                    this.startLoc = player.getEyeLocation().clone();
                    this.alreadyHit.add(player.getUniqueId());
                    player.getWorld().playSound(player.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
                }
                if (this.i > 50) {
                    player.playSound(player.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 0.6f, 1.0f);
                    this.cancel();
                    return;
                }
                long time = System.currentTimeMillis();
                for (int ray = 0; ray < 10000; ++ray) {
                    double dy = 1.0 - 2.0 * ((double)ray / 9999.0);
                    double radius = Math.sqrt(1.0 - dy * dy);
                    double theta = 3.88322207745093 * (double)ray;
                    double dx = Math.cos(theta) * radius;
                    double dz = Math.sin(theta) * radius;
                    Vector offset = new Vector(dx, dy, dz).multiply(0.4 * (double)this.i);
                    Location loc = this.startLoc.clone().add(offset);
                    for (Entity e2 : player.getWorld().getNearbyEntities(loc, 0.5, 0.5, 0.5, e -> e instanceof LivingEntity)) {
                        LivingEntity le = (LivingEntity)e2;
                        if (this.alreadyHit.contains(le.getUniqueId())) continue;
                        if (!(le instanceof EnderDragon)) {
                            le.setVelocity(le.getVelocity().add(offset.normalize().multiply(PlutoniumBladeListener.this.KNOCKBACK_STRENGTH)));
                        }
                        le.setFireTicks(200);
                        if (PlutoniumBladeListener.this.plugin.minorItemListener.withers.contains(le.getUniqueId())) {
                            le.damage(PlutoniumBladeListener.this.DAMAGE * 0.4, (Entity)player);
                        } else {
                            le.damage(PlutoniumBladeListener.this.DAMAGE, (Entity)player);
                        }
                        this.alreadyHit.add(le.getUniqueId());
                    }
                    loc.getWorld().spawnParticle(Particle.SMALL_FLAME, loc, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 15L, 2L);
        this.cooldown.put(player.getUniqueId(), false);
        new BukkitRunnable(){

            public void run() {
                PlutoniumBladeListener.this.cooldown.put(player.getUniqueId(), true);
            }
        }.runTaskLater((Plugin)this.plugin, this.COOLDOWN_TICKS);
    }
}

