/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.NapalmMissile;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.util.Vector;

public class NapalmItemListener
implements Listener {
    private final float MISSILE_EXPLOSIVE_POWER;
    private final float MISSILE_FIRE_POWER;
    private final List<UUID> missiles = new ArrayList<UUID>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public NapalmItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.MISSILE_EXPLOSIVE_POWER = (float)plugin.getConfig().getDouble("napalmMissile.explosive_power", 6.0);
        this.MISSILE_FIRE_POWER = (float)plugin.getConfig().getDouble("napalmMissile.fire_power", 14.0);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Location eventLoc = event.getEntity().getLocation();
        Vector velocity = event.getEntity().getVelocity();
        if (this.missiles.contains(event.getEntity().getUniqueId())) {
            Player player = (Player)event.getEntity().getShooter();
            double magnitude = Math.min(velocity.length() * 0.1, 0.2);
            Location explosionLocation = eventLoc.clone().subtract(velocity.normalize().multiply(magnitude));
            eventLoc.getWorld().createExplosion(eventLoc, this.MISSILE_EXPLOSIVE_POWER, false, true);
            eventLoc.getWorld().createExplosion(eventLoc, this.MISSILE_FIRE_POWER, true, false);
            player.sendMessage("\u00a73FWOOM!");
        }
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntity().getType() != EntityType.SNOWBALL) {
            return;
        }
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity().getShooter();
        if (player == null) {
            return;
        }
        if (!this.util.checkForNapalmMissile(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.napalm.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.napalm.use\u00a73.");
            return;
        }
        this.missiles.add(event.getEntity().getUniqueId());
    }
}

