/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.LifeHelmet;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class LifeHelmetListener
implements Listener {
    public Map<UUID, Integer> cooldown = new HashMap<UUID, Integer>();
    private final long COOLDOWN_TICKS;
    private final WeaponMasterMain plugin;
    private final Util util;

    public LifeHelmetListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.COOLDOWN_TICKS = plugin.getConfig().getLong("lifehelmet.cooldown_ticks", 12000L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        final Player player = (Player)event.getEntity();
        if (!this.util.checkForLifeHelmet(player.getInventory().getHelmet())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.lifehelmet.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.lifehelmet.use\u00a73.");
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.VOID) {
            return;
        }
        if (this.cooldown.getOrDefault(player.getUniqueId(), 0) == 0 && player.getHealth() + player.getAbsorptionAmount() - event.getFinalDamage() <= 0.0) {
            player.setHealth(1.0);
            player.setAbsorptionAmount(0.0);
            event.setDamage(1.0E-6);
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 300, 1, true));
            player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 300, 4, true));
            player.sendTitle("\u00a7cYou were saved from death!", "", 0, 100, 100);
            player.sendMessage("\u00a79------------------------------");
            player.sendMessage("\u00a7eYou were saved from death!");
            player.sendMessage("\u00a79------------------------------");
            player.getWorld().playSound((Entity)player, Sound.ITEM_TOTEM_USE, 4.0f, 1.0f);
            final int cooldownNonce = (int)(1.0 + Math.random() * 2.147483645E9);
            this.cooldown.put(player.getUniqueId(), cooldownNonce);
            new BukkitRunnable(){

                public void run() {
                    if (LifeHelmetListener.this.cooldown.get(player.getUniqueId()) == cooldownNonce) {
                        LifeHelmetListener.this.cooldown.put(player.getUniqueId(), 0);
                        player.sendMessage("\u00a7eYour Helmet of Life cooldown is over!");
                    } else {
                        player.sendMessage("\u00a77[Debug] refusing to reset! expected nonce: " + cooldownNonce + " actual nonce: " + String.valueOf(LifeHelmetListener.this.cooldown.get(player.getUniqueId())));
                    }
                }
            }.runTaskLater((Plugin)this.plugin, this.COOLDOWN_TICKS);
        }
    }
}

