/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.Helios;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class HeliosItemListener
implements Listener {
    private final double IMPACT_DISTANCE;
    private final double IMPACT_DISTANCE_SQUARED;
    private final float FOOD_COST;
    private final int MAX_DAMAGE_LEVEL;
    private final double DAMAGE_INCREASE_PER_LEVEL;
    private final WeaponMasterMain plugin;
    private final Util util;

    public HeliosItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.IMPACT_DISTANCE = plugin.getConfig().getDouble("helios.impact_distance", 5.0);
        this.IMPACT_DISTANCE_SQUARED = this.IMPACT_DISTANCE * this.IMPACT_DISTANCE;
        this.FOOD_COST = (float)plugin.getConfig().getDouble("helios.food_cost", 2.666666);
        this.MAX_DAMAGE_LEVEL = plugin.getConfig().getInt("helios.max_damage_level", 80);
        double maxDamageAmount = plugin.getConfig().getDouble("helios.max_damage_amount", 0.5);
        this.DAMAGE_INCREASE_PER_LEVEL = maxDamageAmount / (double)this.MAX_DAMAGE_LEVEL;
    }

    private double damageMultiply(Player player, double damage) {
        double multiplier = this.DAMAGE_INCREASE_PER_LEVEL * (double)Math.min(player.getLevel(), this.MAX_DAMAGE_LEVEL);
        return damage * (1.0 + multiplier);
    }

    private double distanceSquaredXZ(Location loc1, Location loc2) {
        double deltaX = loc1.getX() - loc2.getX();
        double deltaZ = loc1.getZ() - loc2.getZ();
        return deltaX * deltaX + deltaZ * deltaZ;
    }

    @EventHandler
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForHelios(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.helios.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.helios.use\u00a73.");
            return;
        }
        event.setDamage(this.damageMultiply(player, event.getDamage()));
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack helios = player.getInventory().getItemInMainHand();
        if (!this.util.checkForHelios(helios)) {
            return;
        }
        if (!player.hasPermission("weaponmaster.helios.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.helios.use\u00a73.");
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        if (player.getFoodLevel() < 12 && player.getGameMode() != GameMode.CREATIVE) {
            player.sendMessage("\u00a77You don't have enough hunger to use this!");
            return;
        }
        Location loc = player.getLocation();
        List entitiesClose = player.getNearbyEntities(this.IMPACT_DISTANCE, this.IMPACT_DISTANCE, this.IMPACT_DISTANCE);
        for (Entity e : entitiesClose) {
            if (!(e instanceof LivingEntity) || this.distanceSquaredXZ(loc, e.getLocation()) > this.IMPACT_DISTANCE_SQUARED) continue;
            LivingEntity target = (LivingEntity)e;
            double damage = 6.0 + (double)helios.getItemMeta().getEnchantLevel(Enchantment.SHARPNESS) * 0.5;
            if (this.plugin.minorItemListener.withers.contains(target.getUniqueId())) {
                damage *= 0.4;
            }
            target.damage(damage, (Entity)player);
            target.setFireTicks(target.getFireTicks() + 200);
            target.setVelocity(target.getVelocity().add(new Vector(0.0, 0.4, 0.0)));
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            player.setExhaustion(player.getExhaustion() + this.FOOD_COST);
        }
        for (int step = 0; step < 280; ++step) {
            double theta = Math.PI * (double)step / 140.0;
            double deltaX = this.IMPACT_DISTANCE * Math.cos(theta);
            double deltaY = this.IMPACT_DISTANCE * Math.sin(theta);
            loc.getWorld().spawnParticle(Particle.FLAME, loc.clone().add(deltaX, 0.0, deltaY), 1, 0.0, 0.0, 0.0, 0.001);
        }
    }
}

