/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.GuidedMissile;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;

public class GuidedMissileTargetSelector
extends BukkitRunnable {
    private final double MAX_DISTANCE;
    private final double RAY_SIZE;
    private final int TICKS_TO_LOCK;
    private final int RETAIN_TARGET_TICKS;
    private final Map<Player, LockState> lockStates = new HashMap<Player, LockState>();
    private final Map<Player, LivingEntity> targets = new HashMap<Player, LivingEntity>();
    private final Map<Player, Integer> ticksOnTarget = new HashMap<Player, Integer>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public GuidedMissileTargetSelector(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.MAX_DISTANCE = plugin.getConfig().getDouble("guidedMissile.max_distance", 96.0);
        this.RAY_SIZE = plugin.getConfig().getDouble("guidedMissile.ray_size", 2.9);
        this.TICKS_TO_LOCK = plugin.getConfig().getInt("guidedMissile.ticks_to_lock", 16);
        this.RETAIN_TARGET_TICKS = plugin.getConfig().getInt("guidedMissile.retain_target_ticks", 70);
    }

    public LockState getLockState(Player player) {
        return this.lockStates.getOrDefault(player, LockState.NONE);
    }

    public void clearLock(Player player) {
        this.lockStates.put(player, LockState.NONE);
    }

    public LivingEntity getTarget(Player player) {
        return this.targets.get(player);
    }

    private String lockActionBarMessage(int ticks) {
        int x = ticks * 4 / this.TICKS_TO_LOCK;
        switch (x) {
            case 0: {
                return "\u00a7a<\u00a77<<<< \u00a7eLocking! \u00a77>>>>\u00a7a>";
            }
            case 1: {
                return "\u00a7a<<\u00a77<<< \u00a7eLocking! \u00a77>>>\u00a7a>>";
            }
            case 2: {
                return "\u00a7a<<<\u00a77<< \u00a7eLocking! \u00a77>>\u00a7a>>>";
            }
        }
        return "\u00a7a<<<<\u00a77< \u00a7eLocking! \u00a77>\u00a7a>>>>";
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("weaponmaster.guidedmissile.use")) continue;
            if (!this.util.checkForGuidedMissile(player.getInventory().getItemInMainHand())) {
                this.clearLock(player);
                continue;
            }
            Location eyeLoc = player.getEyeLocation();
            RayTraceResult ray = eyeLoc.getWorld().rayTrace(eyeLoc, eyeLoc.getDirection(), this.MAX_DISTANCE, FluidCollisionMode.NEVER, true, this.RAY_SIZE, e -> e instanceof LivingEntity && !e.equals(player));
            if (ray == null || ray.getHitEntity() == null || !ray.getHitEntity().equals(this.getTarget(player)) && this.getLockState(player) != LockState.NONE) {
                if (this.getLockState(player) == LockState.LOCKED) {
                    this.ticksOnTarget.put(player, this.ticksOnTarget.get(player) - 1);
                    if (this.ticksOnTarget.get(player) <= 0) {
                        this.clearLock(player);
                        this.plugin.paperUtils.sendActionBar(player, "\u00a7cTarget lost!", true);
                        continue;
                    }
                    this.plugin.paperUtils.sendActionBar(player, "\u00a7c< \u00a7aTarget held! \u00a7c> ", true);
                    continue;
                }
                if (this.getLockState(player) == LockState.NONE) continue;
                this.clearLock(player);
                this.plugin.paperUtils.sendActionBar(player, "\u00a7cTarget lost!", true);
                continue;
            }
            LivingEntity target = (LivingEntity)ray.getHitEntity();
            if (this.getLockState(player) == LockState.LOCKED) {
                this.ticksOnTarget.put(player, this.RETAIN_TARGET_TICKS);
                this.plugin.paperUtils.sendActionBar(player, "\u00a7c<<<<< \u00a7aLocked! \u00a7c>>>>>", true);
                continue;
            }
            if (this.getLockState(player) == LockState.NONE) {
                this.lockStates.put(player, LockState.LOCKING);
                this.targets.put(player, target);
                this.ticksOnTarget.put(player, 0);
                this.plugin.paperUtils.sendActionBar(player, this.lockActionBarMessage(0), true);
                target.getWorld().spawnParticle(Particle.FLAME, target.getEyeLocation(), 500, 0.0, 0.0, 0.0, 0.3);
                continue;
            }
            if (this.getLockState(player) != LockState.LOCKING) continue;
            this.ticksOnTarget.put(player, this.ticksOnTarget.get(player) + 1);
            if (this.ticksOnTarget.get(player) >= this.TICKS_TO_LOCK) {
                this.lockStates.put(player, LockState.LOCKED);
                this.ticksOnTarget.put(player, this.RETAIN_TARGET_TICKS);
                this.plugin.paperUtils.sendActionBar(player, "\u00a7c<<<<< \u00a7aLocked! \u00a7c>>>>>", true);
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                continue;
            }
            this.plugin.paperUtils.sendActionBar(player, this.lockActionBarMessage(this.ticksOnTarget.get(player)), true);
        }
    }

    public static enum LockState {
        NONE,
        LOCKING,
        LOCKED;

    }
}

