/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.GuidedMissile;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.mainitems.GuidedMissile.GuidedMissileTargetSelector;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GuidedMissileManager
implements Listener {
    private final float BLOCK_EXPLOSION_POWER;
    private final float ENTITY_EXPLOSION_POWER;
    private final float WEAK_EXPLOSION_POWER;
    private final double PROXIMITY_DISTANCE_SQUARED;
    private final double ACCELERATION;
    private final double AIR_RESISTANCE;
    private final WeaponMasterMain plugin;
    private final Util util;
    private final GuidedMissileTargetSelector targetSelector;

    public GuidedMissileManager(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.targetSelector = new GuidedMissileTargetSelector(plugin);
        this.BLOCK_EXPLOSION_POWER = (float)plugin.getConfig().getDouble("guidedMissile.block_explosion_power", 6.0);
        this.ENTITY_EXPLOSION_POWER = (float)plugin.getConfig().getDouble("guidedMissile.entity_explosion_power", 19.0);
        this.WEAK_EXPLOSION_POWER = (float)plugin.getConfig().getDouble("guidedMissile.weak_explosion_power", 5.0);
        double proximityDistance = plugin.getConfig().getDouble("guidedMissile.proximity_distance", 6.5);
        this.PROXIMITY_DISTANCE_SQUARED = proximityDistance * proximityDistance;
        this.ACCELERATION = plugin.getConfig().getDouble("guidedMissile.acceleration", 0.63);
        this.AIR_RESISTANCE = plugin.getConfig().getDouble("guidedMissile.air_resistance", 0.73);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForGuidedMissile(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.guidedmissile.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.guidedmissile.use\u00a73.");
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        if (this.targetSelector.getLockState(player) != GuidedMissileTargetSelector.LockState.LOCKED) {
            player.sendMessage("\u00a73No target selected!");
            return;
        }
        final LivingEntity target = this.targetSelector.getTarget(player);
        Location eyeLocation = player.getEyeLocation();
        Location spawnLoc = eyeLocation.add(eyeLocation.getDirection().multiply(0.9));
        World world = player.getWorld();
        final Fireball fireball = (Fireball)world.spawnEntity(spawnLoc, EntityType.FIREBALL);
        fireball.setVelocity(player.getVelocity());
        fireball.setYield(this.WEAK_EXPLOSION_POWER);
        fireball.setShooter((ProjectileSource)player);
        this.targetSelector.clearLock(player);
        new BukkitRunnable(){
            int tickNumber = 0;

            public void run() {
                ++this.tickNumber;
                if (fireball.isDead()) {
                    this.cancel();
                    return;
                }
                Location fireballLoc = fireball.getLocation();
                int NUMBER_PARTICLES = 10;
                Vector displacement = fireball.getVelocity();
                for (int i = 0; i < 10; ++i) {
                    Location loc = fireballLoc.subtract(displacement.clone().multiply((double)i / 10.0));
                    fireball.getWorld().spawnParticle(Particle.FLAME, loc, 5, 0.0, 0.0, 0.0, 0.05);
                    fireball.getWorld().spawnParticle(Particle.LARGE_SMOKE, loc, 2, 0.0, 0.0, 0.0, 0.025);
                }
                if (fireballLoc.distanceSquared(target.getLocation()) < GuidedMissileManager.this.PROXIMITY_DISTANCE_SQUARED) {
                    fireball.getWorld().createExplosion(fireballLoc, GuidedMissileManager.this.BLOCK_EXPLOSION_POWER, true, true, (Entity)fireball);
                    fireball.getWorld().createExplosion(fireballLoc, GuidedMissileManager.this.ENTITY_EXPLOSION_POWER, false, false, (Entity)fireball);
                    target.damage(1000000.0, (Entity)fireball);
                    fireball.remove();
                    this.cancel();
                    return;
                }
                if (fireballLoc.distanceSquared(target.getLocation()) > 90000.0) {
                    fireball.remove();
                    this.cancel();
                    return;
                }
                Vector desiredDirection = target.getLocation().subtract(fireballLoc).toVector().normalize();
                double realAcceleration = this.tickNumber >= 20 ? GuidedMissileManager.this.ACCELERATION : 0.05 * (double)this.tickNumber * GuidedMissileManager.this.ACCELERATION;
                Vector newVelocity = fireball.getVelocity().multiply(GuidedMissileManager.this.AIR_RESISTANCE).add(desiredDirection.multiply(realAcceleration));
                fireball.setVelocity(newVelocity);
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            player.getInventory().getItemInMainHand().setAmount(player.getInventory().getItemInMainHand().getAmount() - 1);
        }
    }

    public void regGuidedMissileRunnable() {
        this.targetSelector.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

