/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.EndSword;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.mainitems.EndSword.EndPowerManager;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class EndSwordListener
implements Listener {
    private static final double RAYTRACE_EXTRA_PADDING = 0.4;
    private static final double RAYTRACE_TOLERANCE = 0.05;
    private final double TELEPORT_DISTANCE;
    private final WeaponMasterMain plugin;
    private final EndPowerManager powerManager;
    private final Util util;

    public EndSwordListener(WeaponMasterMain plugin, EndPowerManager powerManager) {
        this.plugin = plugin;
        this.powerManager = powerManager;
        this.util = new Util(null);
        this.TELEPORT_DISTANCE = plugin.getConfig().getDouble("endsword.teleport_distance", 7.0);
    }

    private static double findMaxRaytraceDistance(Player player, double min, double max, boolean isFirstRun) {
        if (max - min < 0.05) {
            return (min + max) / 2.0;
        }
        double test = isFirstRun ? max : (min + max) / 2.0;
        RayTraceResult rtxResult = player.getWorld().rayTraceBlocks(player.getEyeLocation(), player.getEyeLocation().getDirection(), test, FluidCollisionMode.NEVER, true);
        if (rtxResult != null && rtxResult.getHitBlock() != null) {
            return EndSwordListener.findMaxRaytraceDistance(player, min, test, false);
        }
        return EndSwordListener.findMaxRaytraceDistance(player, test, max, false);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForEndSword(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.endsword.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.endsword.use\u00a73.");
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        if (this.powerManager.getPower(player) < 10) {
            player.sendMessage("\u00a77You don't have enough power to teleport!");
            return;
        }
        double teleportDistance = EndSwordListener.findMaxRaytraceDistance(player, 0.0, this.TELEPORT_DISTANCE + 0.4, true) - 0.4;
        if (teleportDistance < this.TELEPORT_DISTANCE / 2.0) {
            player.sendMessage("\u00a77You can't teleport through blocks!");
            return;
        }
        Vector tp = player.getEyeLocation().getDirection().multiply(teleportDistance);
        player.playSound((Entity)player, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        player.teleport(player.getEyeLocation().add(tp));
        this.powerManager.incrementPower(player, -10);
    }
}

