/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.DragonSword;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.mainitems.DragonSword.DragonSwordUpgradeListener;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class DragonSwordListener
implements Listener {
    private final double A;
    private final double B;
    private final double C;
    private final double DRAGON_ARMOR_BUFF;
    private final WeaponMasterMain plugin;
    private final Util util;
    private final DragonSwordUpgradeListener dragonUpgrade;

    public DragonSwordListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.dragonUpgrade = new DragonSwordUpgradeListener(plugin);
        this.A = plugin.getConfig().getDouble("dragonsword.a", 0.0);
        this.B = plugin.getConfig().getDouble("dragonsword.b", 0.8);
        this.C = plugin.getConfig().getDouble("dragonsword.c", 0.25);
        this.DRAGON_ARMOR_BUFF = plugin.getConfig().getDouble("dragonsword.dragon_armor_buff", 1.25);
    }

    private double triangular(double random) {
        double F = (this.C - this.A) / (this.B - this.A);
        if (random < F) {
            return this.A + Math.sqrt(random * (this.B - this.A) * (this.C - this.A));
        }
        return this.B - Math.sqrt((1.0 - random) * (this.B - this.A) * (this.B - this.C));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForDragonSword(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.dragonsword.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.dragonsword.use\u00a73.");
            return;
        }
        if (Math.random() < this.dragonUpgrade.abilityTriggerProbability(player.getInventory().getItemInMainHand().getItemMeta().getLore())) {
            double multiplier = 1.0 + this.triangular(Math.random());
            if (this.util.checkForDragonArmor(player.getInventory().getHelmet()) && this.util.checkForDragonArmor(player.getInventory().getChestplate()) && this.util.checkForDragonArmor(player.getInventory().getLeggings()) && this.util.checkForDragonArmor(player.getInventory().getBoots())) {
                multiplier *= this.DRAGON_ARMOR_BUFF;
            }
            event.setDamage(event.getDamage() * multiplier);
            this.plugin.paperUtils.sendActionBar(player, String.format("\u00a73Hit increased by \u00a74%.1f%% \u00a73for \u00a74%.1f\u00a73.", (multiplier - 1.0) * 100.0, event.getDamage()), true);
        }
    }
}

