/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.DragonElytra;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ElytraItemListener
implements Listener {
    private final double BONUS_MAX;
    private final double BONUS_MIN;
    private final double ENDER_EYE_BONUS;
    private final WeaponMasterMain plugin;
    private final Util util;

    public ElytraItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.BONUS_MAX = plugin.getConfig().getDouble("dragonelytra.bonus_max", 0.01);
        this.BONUS_MIN = plugin.getConfig().getDouble("dragonelytra.bonus_min", 0.005);
        this.ENDER_EYE_BONUS = plugin.getConfig().getDouble("dragonelytra.ender_eye_bonus", 7.5);
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (Util.checkForInteractableBlock(event)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForDragonElytra(player.getInventory().getChestplate())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.dragonelytra.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.dragonelytra.use\u00a73.");
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() == Material.ENDER_EYE) {
            Vector bonus = player.getEyeLocation().getDirection().multiply(this.ENDER_EYE_BONUS);
            player.setVelocity(player.getVelocity().add(bonus));
            player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.ENDER_EYE, 1)});
            event.setCancelled(true);
        }
    }

    public ElytraItemListener regDragonElytraRunnable() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("weaponmaster.dragonelytra.use") || !ElytraItemListener.this.util.checkForDragonElytra(player.getInventory().getChestplate()) || !player.isGliding()) continue;
                    double playerVelocity = player.getVelocity().length();
                    double bonusMagnitude = playerVelocity <= 1.25 ? ElytraItemListener.this.BONUS_MAX : (playerVelocity <= 1.75 ? ElytraItemListener.this.BONUS_MIN + (ElytraItemListener.this.BONUS_MAX - ElytraItemListener.this.BONUS_MIN) * (1.0 - 2.0 * (playerVelocity - 1.25)) : ElytraItemListener.this.BONUS_MIN);
                    Vector bonus = player.getEyeLocation().getDirection().multiply(bonusMagnitude);
                    player.setVelocity(player.getVelocity().add(bonus));
                    player.spawnParticle(Particle.SMALL_FLAME, player.getLocation(), 3, 0.0, 0.0, 0.0, 0.001);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 200L, 1L);
        return this;
    }
}

