/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.BombCannon;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;

public class BombCannonListener
implements Listener {
    private final float EXPLOSION_POWER;
    private final Set<UUID> explosiveArrows = new HashSet<UUID>();
    private final Util util;

    public BombCannonListener(WeaponMasterMain plugin) {
        this.util = new Util(plugin);
        this.EXPLOSION_POWER = (float)plugin.getConfig().getDouble("bombcannon.explosion_power", 1.25);
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        Entity arrow = event.getProjectile();
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!this.util.checkForBombCannon(event.getBow())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.bombcannon.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.bombcannon.use\u00a73.");
            return;
        }
        if ((double)event.getForce() < 0.99) {
            player.sendMessage("\u00a77Explosive arrows can only be fired when fully charged.");
            return;
        }
        this.explosiveArrows.add(arrow.getUniqueId());
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile arrow = event.getEntity();
        if (this.explosiveArrows.contains(arrow.getUniqueId())) {
            arrow.getWorld().createExplosion(arrow.getLocation(), this.EXPLOSION_POWER, false, true, (Entity)arrow);
            this.explosiveArrows.remove(arrow.getUniqueId());
            arrow.remove();
        }
    }
}

