/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.ArtemisBow;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.mainitems.ArtemisBow.ArtemisMode;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ArtemisItemListener
implements Listener {
    private final double SEEKING_DISTANCE;
    private Map<String, ArtemisMode> artemisModes = new HashMap<String, ArtemisMode>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public ArtemisItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.SEEKING_DISTANCE = plugin.getConfig().getDouble("artemis.seeking_distance", 3.8);
    }

    private double doCompensation(int runNumber, ArtemisMode mode) {
        switch (mode) {
            case WEAK: {
                if (runNumber <= 9) {
                    return 0.01;
                }
                if (runNumber <= 19) {
                    return 0.25 * this.SEEKING_DISTANCE;
                }
                if (runNumber <= 29) {
                    return 0.5 * this.SEEKING_DISTANCE;
                }
                if (runNumber <= 39) {
                    return 0.75 * this.SEEKING_DISTANCE;
                }
                return this.SEEKING_DISTANCE;
            }
            case STRONGEST: {
                return this.SEEKING_DISTANCE;
            }
        }
        if (runNumber <= 2) {
            return 0.01;
        }
        if (runNumber <= 7) {
            return 0.5 * this.SEEKING_DISTANCE;
        }
        return this.SEEKING_DISTANCE;
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        final Entity arrow = event.getProjectile();
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        final Player player = (Player)event.getEntity();
        if (!this.util.checkForArtemisBow(event.getBow())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.artemisbow.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.artemisbow.use\u00a73.");
            return;
        }
        if ((double)event.getForce() < 0.99) {
            player.sendMessage("\u00a77Heat seeking only functions for fully charged shots!");
            return;
        }
        if (this.artemisModes.get(player.getUniqueId().toString()) == ArtemisMode.DISABLED) {
            player.sendMessage("\u00a77Heat seeking was disabled, LEFT CLICK with Artemis to toggle.");
            return;
        }
        new BukkitRunnable(){
            ArtemisMode mode;
            int runs;
            int maxCurves;
            int curveCoolDown;
            {
                this.mode = ArtemisItemListener.this.artemisModes.getOrDefault(player.getUniqueId().toString(), ArtemisMode.NORMAL);
                this.runs = 0;
                this.maxCurves = 9;
                this.curveCoolDown = 0;
            }

            public void run() {
                ++this.runs;
                if (arrow.isOnGround() || arrow.isDead()) {
                    this.cancel();
                } else if (this.maxCurves <= 0) {
                    this.cancel();
                } else if (this.curveCoolDown != 0) {
                    --this.curveCoolDown;
                } else {
                    Location arrowLoc = arrow.getLocation();
                    arrow.getWorld().spawnParticle(Particle.FLAME, arrowLoc, 2);
                    double seekingDistance = ArtemisItemListener.this.doCompensation(this.runs, this.mode);
                    List nearEntities = arrow.getNearbyEntities(seekingDistance, seekingDistance, seekingDistance);
                    nearEntities.sort((a, b) -> (int)(1000.0 * (a.getLocation().distanceSquared(arrowLoc) - b.getLocation().distanceSquared(arrowLoc))));
                    for (Entity target : nearEntities) {
                        GameMode gm;
                        if (target instanceof Enderman || target instanceof Player && ((gm = ((Player)target).getGameMode()) == GameMode.CREATIVE || gm == GameMode.SPECTATOR) || !player.hasLineOfSight(target) || !(target instanceof LivingEntity) || target.isDead() || target.getEntityId() == player.getEntityId()) continue;
                        Vector velo = arrow.getVelocity();
                        double speed = Math.sqrt(velo.getX() * velo.getX() + velo.getY() * velo.getY() + velo.getZ() * velo.getZ());
                        arrow.setVelocity(target.getLocation().toVector().subtract(arrow.getLocation().toVector()).normalize().multiply(speed));
                        arrow.getWorld().spawnParticle(Particle.FLAME, arrowLoc, 150);
                        --this.maxCurves;
                        this.curveCoolDown = 4;
                        break;
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForArtemisBow(player.getInventory().getItemInMainHand())) {
            return;
        }
        ArtemisMode currentMode = this.artemisModes.getOrDefault(player.getUniqueId().toString(), ArtemisMode.NORMAL);
        if (currentMode == ArtemisMode.DISABLED) {
            this.artemisModes.put(player.getUniqueId().toString(), ArtemisMode.WEAK);
            player.sendMessage("\u00a73Artemis Bow set to \u00a74weak\u00a73.");
        } else if (currentMode == ArtemisMode.WEAK) {
            this.artemisModes.put(player.getUniqueId().toString(), ArtemisMode.NORMAL);
            player.sendMessage("\u00a73Artemis Bow set to \u00a74normal\u00a73.");
        } else if (currentMode == ArtemisMode.NORMAL) {
            this.artemisModes.put(player.getUniqueId().toString(), ArtemisMode.STRONGEST);
            player.sendMessage("\u00a73Artemis Bow set to \u00a74strongest\u00a73.");
        } else if (currentMode == ArtemisMode.STRONGEST) {
            this.artemisModes.put(player.getUniqueId().toString(), ArtemisMode.DISABLED);
            player.sendMessage("\u00a73Artemis Bow set to \u00a74disabled\u00a73.");
        }
    }
}

