/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragondescent;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.MathHelper;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class DescentDataManager {
    public final String DESCENT_GUI_NAME = "\u00a77\u00a7k~~\u00a7r\u00a75 Dragon's Descent \u00a77\u00a7k~~";
    public final int MAX_LEVEL = 5;
    public final int SHARDS_TO_POWER = 160;
    private final WeaponMasterMain plugin;
    public final boolean isEnabled;
    private final File descentFile;
    private final YamlConfiguration config;

    public DescentDataManager(WeaponMasterMain plugin, boolean isEnabled) {
        this.plugin = plugin;
        this.isEnabled = isEnabled;
        this.descentFile = new File(plugin.getDataFolder(), "descent.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.descentFile);
    }

    public void saveDataToConfig() {
        try {
            this.config.save(this.descentFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear(UUID target) {
        this.config.set("descent." + String.valueOf(target), null);
        this.saveDataToConfig();
    }

    public int getUpgrade(UUID target, String upgradeName) {
        String path = "descent." + String.valueOf(target) + "." + upgradeName;
        return this.config.getInt(path, 0);
    }

    public int getUpgrade(Player target, String upgradeName) {
        return this.getUpgrade(target.getUniqueId(), upgradeName);
    }

    public void setUpgrade(UUID target, String upgradeName, int newValue) {
        String path = "descent." + String.valueOf(target) + "." + upgradeName;
        this.config.set(path, (Object)newValue);
        this.saveDataToConfig();
    }

    public boolean incrementDescent(UUID target, String upgradeName) {
        int price = this.getPrice(this.getPurchases(target) + 1);
        if (this.getDragonPower(target) < price) {
            return false;
        }
        this.setPurchases(target, this.getPurchases(target) + 1);
        this.setDragonPower(target, this.getDragonPower(target) - price);
        this.setUpgrade(target, upgradeName, this.getUpgrade(target, upgradeName) + 1);
        return true;
    }

    public void updateShards(UUID target) {
        int powerAmount = this.getShards(target) / 160;
        if (powerAmount > 0) {
            this.setDragonPower(target, this.getDragonPower(target) + powerAmount);
            this.setShards(target, this.getShards(target) - 160 * powerAmount);
        }
    }

    public int getShards(UUID target) {
        return this.getUpgrade(target, "__shards__");
    }

    public void setShards(UUID target, int value) {
        this.setUpgrade(target, "__shards__", value);
    }

    public void addShards(Player target, int value) {
        double multi = 1.0 + 0.025 * (double)this.getUpgrade(target, "shardSeeker");
        int newValue = MathHelper.roundProbability((double)value * multi);
        this.setShards(target.getUniqueId(), this.getShards(target.getUniqueId()) + newValue);
    }

    public int getDragonPower(UUID target) {
        return this.getUpgrade(target, "__power__");
    }

    public void setDragonPower(UUID target, int value) {
        this.setUpgrade(target, "__power__", value);
    }

    public int getPurchases(UUID target) {
        return this.getUpgrade(target, "__purchases__");
    }

    public void setPurchases(UUID target, int value) {
        this.setUpgrade(target, "__purchases__", value);
    }

    public int getPrice(int purchase) {
        if (purchase > 90) {
            return purchase - 86;
        }
        if (purchase > 70) {
            return 4;
        }
        if (purchase > 50) {
            return 3;
        }
        if (purchase > 30) {
            return 2;
        }
        return 1;
    }
}

