/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragondescent;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.dragondescent.DescentDataManager;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AttributeChanger
implements Listener {
    private final UUID extraAttackSpeedUUID = UUID.fromString("00000000-1111-0000-0000-68e91d3e87c2");
    private final UUID tougherArmorUUID = UUID.fromString("00000000-1111-0000-0000-eb63bfa7d783");
    private final UUID runnerUUID = UUID.fromString("00000000-1111-0000-0000-f3789ac34a8a");
    private final WeaponMasterMain plugin;
    private final DescentDataManager descent;

    public AttributeChanger(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.descent = plugin.descent;
    }

    private AttributeModifier searchExistingAM(AttributeInstance instance, UUID withUUID) {
        for (AttributeModifier am : instance.getModifiers()) {
            if (!am.getUniqueId().equals(withUUID)) continue;
            double oldAmount = am.getAmount();
            return am;
        }
        return null;
    }

    public void updateAttributes(Player player) {
        int extraAttackSpeed = this.descent.getUpgrade(player, "extraAttackSpeed");
        AttributeModifier existingAttackSpeedAM = this.searchExistingAM(player.getAttribute(Attribute.GENERIC_ATTACK_SPEED), this.extraAttackSpeedUUID);
        if (existingAttackSpeedAM != null) {
            player.getAttribute(Attribute.GENERIC_ATTACK_SPEED).removeModifier(existingAttackSpeedAM);
        }
        if (extraAttackSpeed > 0) {
            double multi = 0.02 * (double)extraAttackSpeed;
            player.getAttribute(Attribute.GENERIC_ATTACK_SPEED).addModifier(new AttributeModifier(this.extraAttackSpeedUUID, "weaponmaster", multi, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        }
        int tougherArmor = this.descent.getUpgrade(player, "tougherArmor");
        AttributeModifier existingArmorToughnessAM = this.searchExistingAM(player.getAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS), this.tougherArmorUUID);
        if (existingArmorToughnessAM != null) {
            player.getAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS).removeModifier(existingArmorToughnessAM);
        }
        if (tougherArmor > 0) {
            double multi = 0.03 * (double)tougherArmor;
            player.getAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS).addModifier(new AttributeModifier(this.tougherArmorUUID, "weaponmaster", multi, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        }
        int runner = this.descent.getUpgrade(player, "runner");
        AttributeModifier existingMovementSpeedAM = this.searchExistingAM(player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED), this.runnerUUID);
        if (existingMovementSpeedAM != null) {
            player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).removeModifier(existingMovementSpeedAM);
        }
        if (runner > 0) {
            double multi = 0.008 * (double)runner;
            player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).addModifier(new AttributeModifier(this.runnerUUID, "weaponmaster", multi, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        }
    }

    public void registerUpdateEveryone() {
        long period = 6000L;
        new BukkitRunnable(){

            public void run() {
                for (Player player : AttributeChanger.this.plugin.getServer().getOnlinePlayers()) {
                    AttributeChanger.this.updateAttributes(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, period, period);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.updateAttributes(event.getPlayer());
    }
}

