/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.TrueDamageHelper;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WeaponMasterCommand
implements CommandExecutor {
    private WeaponMasterMain plugin;

    public WeaponMasterCommand(WeaponMasterMain plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length >= 1 && args[0].equals("debug")) {
            Player player = (Player)sender;
            TrueDamageHelper.dealTrueDamage((LivingEntity)player, 30.0);
            player.sendMessage("\u00a77I just damaged you for 30 true damage!");
        }
        if (args.length >= 1 && args[0].equals("debug1")) {
            sender.sendMessage("\u00a77dragon: " + String.valueOf(this.plugin.dragonManager.currentlyActiveDragon));
            sender.sendMessage("\u00a77explosive damage dealt: " + this.plugin.dragonManager.damageDealtToDragonThroughExplosions);
            sender.sendMessage("\u00a77current hp: \u00a7c" + this.plugin.dragonManager.currentlyActiveDragon.getHealth());
            return true;
        }
        if (args.length >= 1 && args[0].equals("attributemodifier")) {
            UUID uuid;
            EquipmentSlot slot;
            double amount;
            AttributeModifier.Operation operation;
            Attribute attribute;
            if (args.length < 5) {
                sender.sendMessage("\u00a7cError: \u00a74Missing arguments: /weaponmaster attributemodifier <attribute> <operation> <amount> <slot> [<optional uuid>]");
                return true;
            }
            try {
                attribute = Attribute.valueOf((String)args[1]);
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid attribute. You need bukkit names, such as 'GENERIC_MAX_HEALTH'.");
                return true;
            }
            try {
                operation = AttributeModifier.Operation.valueOf((String)args[2]);
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid operation. Choose from 'ADD_NUMBER', 'ADD_SCALAR', 'MULTIPLY_SCALAR_1'");
                return true;
            }
            try {
                amount = Double.parseDouble(args[3]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid number. Please give a decimal value.");
                return true;
            }
            try {
                slot = EquipmentSlot.valueOf((String)args[4]);
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid equipment slot. You need bukkit names, such as 'HEAD'.");
                return true;
            }
            if (args.length >= 6) {
                try {
                    uuid = UUID.fromString(args[5]);
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage("\u00a7cError: \u00a74Invalid UUID provided, try leaving it blank.");
                    return true;
                }
            } else {
                uuid = UUID.randomUUID();
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cError: \u00a74Must be a player.");
                return true;
            }
            Player player = (Player)sender;
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            ItemMeta im = itemStack.getItemMeta();
            if (im == null) {
                sender.sendMessage("\u00a7cError: \u00a74This item does not have any ItemMeta.");
                return true;
            }
            im.addAttributeModifier(attribute, new AttributeModifier(uuid, "weaponmaster", amount, operation, slot));
            itemStack.setItemMeta(im);
            player.sendMessage(String.format("\u00a73Successfully added attribute modifier \u00a74%s\u00a73.", uuid));
            return true;
        }
        if (args.length >= 1 && args[0].equals("illegalstack")) {
            int amount;
            if (args.length < 2) {
                sender.sendMessage("\u00a7cError: \u00a74Missing arguments: /weaponmaster illegalstack <number>");
                return true;
            }
            try {
                amount = args[1].equalsIgnoreCase("max") ? 99 : Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid number.");
                return true;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cError: \u00a74Must be a player.");
                return true;
            }
            if (amount > 99) {
                sender.sendMessage("\u00a76Warning: Stack sizes above 99 will not save and can cause data loss or duplication exploits!");
            }
            ((Player)sender).getInventory().getItemInMainHand().setAmount(amount);
            sender.sendMessage(String.format("\u00a73Set stack size to \u00a74%d\u00a73.", amount));
            return true;
        }
        if (args.length >= 1 && args[0].equals("vanillastack")) {
            int amount;
            if (args.length < 2) {
                sender.sendMessage("\u00a7cError: \u00a74Missing arguments: /weaponmaster vanillastack <number>");
                return true;
            }
            try {
                amount = args[1].equalsIgnoreCase("max") ? 99 : Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid number.");
                return true;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cError: \u00a74Must be a player.");
                return true;
            }
            amount = Math.min(Math.max(amount, 1), 99);
            ItemStack stack = ((Player)sender).getInventory().getItemInMainHand();
            ItemMeta im = stack.getItemMeta();
            if (im == null) {
                sender.sendMessage("\u00a73The stack size of this item can't be changed!");
                return true;
            }
            im.setMaxStackSize(Integer.valueOf(amount));
            stack.setItemMeta(im);
            stack.setAmount(amount);
            sender.sendMessage(String.format("\u00a73Set stack size to \u00a74%d\u00a73.", amount));
            return true;
        }
        if (args.length >= 1 && args[0].equals("forceenchant")) {
            int level;
            Enchantment enchant;
            if (args.length < 3) {
                sender.sendMessage("\u00a7cError: \u00a74Missing arguments: /weaponmaster forceenchant <enchant> <level>");
                return true;
            }
            try {
                enchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)args[1]));
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid enchantment. Try using Minecraft namespaced IDs.");
                return true;
            }
            try {
                level = args[2].equalsIgnoreCase("max") ? 255 : Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid number. Please give an int, or use 'max'.");
                return true;
            }
            if (enchant == null) {
                sender.sendMessage("\u00a7cError: \u00a74That enchant does not exist. Try using Minecraft namespaced IDs.");
                return true;
            }
            if (level > 255) {
                level = 255;
                sender.sendMessage("\u00a7cWarning: \u00a74Enchantment level in 1.18 is limited to 255.");
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cError: \u00a74Must be a player.");
                return true;
            }
            ItemStack stack = ((Player)sender).getInventory().getItemInMainHand();
            ItemMeta im = stack.getItemMeta();
            if (im == null) {
                sender.sendMessage("\u00a7cError: \u00a74This item does not have any ItemMeta.");
                return true;
            }
            if (level <= 0) {
                im.removeEnchant(enchant);
                stack.setItemMeta(im);
                sender.sendMessage(String.format("\u00a73Removed enchant \u00a74%s\u00a73!", enchant.getKey()));
            } else {
                im.addEnchant(enchant, level, true);
                stack.setItemMeta(im);
                sender.sendMessage(String.format("\u00a73Added \u00a74%s \u00a73level \u00a74%d\u00a73!", enchant.getKey(), level));
            }
            return true;
        }
        if (args.length >= 1 && args[0].equals("addpotioneffect")) {
            int amplifier;
            int lengthTicks;
            PotionEffectType potionEffectType;
            if (args.length < 4) {
                sender.sendMessage("\u00a7cError: \u00a74Missing arguments: /weaponmaster forceenchant <effect type> <duration (seconds)> <amplifier>");
                return true;
            }
            try {
                potionEffectType = PotionEffectType.getByKey((NamespacedKey)NamespacedKey.minecraft((String)args[1]));
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid potion effect type. Try using Minecraft namespaced IDs.");
                return true;
            }
            if (potionEffectType == null) {
                sender.sendMessage("\u00a7cError: \u00a74That potion effect type does not exist. Try using Minecraft namespaced IDs.");
                return true;
            }
            if (args[2].equalsIgnoreCase("max")) {
                lengthTicks = Integer.MAX_VALUE;
            } else {
                double lengthSeconds;
                try {
                    lengthSeconds = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7cError: \u00a74You gave an invalid number. Please give a decimal value, or use 'max'.");
                    return true;
                }
                lengthTicks = Math.min(Math.max((int)(lengthSeconds * 20.0), 1), Integer.MAX_VALUE);
            }
            try {
                amplifier = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cError: \u00a74You gave an invalid number. Please give an int.");
                return true;
            }
            if (amplifier < 0 || amplifier > 127) {
                sender.sendMessage("\u00a7cError: \u00a74Amplifier must be between 0 and 127.");
                return true;
            }
            ItemStack stack = ((Player)sender).getInventory().getItemInMainHand();
            ItemMeta im = stack.getItemMeta();
            if (im == null) {
                sender.sendMessage("\u00a7cError: \u00a74This item does not have any ItemMeta.");
                return true;
            }
            if (!(im instanceof PotionMeta)) {
                sender.sendMessage("\u00a7cError: \u00a74This item does not support potion effects.");
                return true;
            }
            PotionMeta pm = (PotionMeta)im;
            pm.addCustomEffect(new PotionEffect(potionEffectType, lengthTicks, amplifier), true);
            stack.setItemMeta((ItemMeta)pm);
            sender.sendMessage("\u00a73Added potion effect!");
            return true;
        }
        sender.sendMessage("----------------------------------------");
        sender.sendMessage("");
        sender.sendMessage("\u00a74\u00a7lWeaponMaster");
        sender.sendMessage("\u00a77\u00a7oby greateric");
        sender.sendMessage("");
        sender.sendMessage("\u00a7e/weaponmaster attributemodifier");
        sender.sendMessage("\u00a7e/weaponmaster illegalstack");
        sender.sendMessage("\u00a7e/weaponmaster vanillastack");
        sender.sendMessage("\u00a7e/weaponmaster forceenchant");
        sender.sendMessage("\u00a7e/weaponmaster addpotioneffect");
        sender.sendMessage("");
        sender.sendMessage("----------------------------------------");
        return true;
    }
}

