/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.NinjaMastersBow;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.InaccuracyAdder;
import io.github.greatericontop.weaponmaster.utils.Util;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class NinjaMastersItemListener
implements Listener {
    private final WeaponMasterMain plugin;
    private final Util util;
    private static final double DTHETA = 0.17453292519943295;

    public NinjaMastersItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    public Arrow spawnArrow(World world, Location location, Vector direction, double velocity, double maxInaccuracyMagnitude, double damageValue, int punchValue, boolean isFire, Player shooterPlayer, AbstractArrow.PickupStatus pickupStatus) {
        Arrow arrow = (Arrow)world.spawnEntity(location, EntityType.ARROW);
        Vector normalVelocity = direction.clone().normalize().multiply(velocity);
        arrow.setVelocity(normalVelocity.add(InaccuracyAdder.generateInaccuracy(maxInaccuracyMagnitude)));
        arrow.setDamage(damageValue);
        arrow.setKnockbackStrength(punchValue);
        arrow.setShooter((ProjectileSource)shooterPlayer);
        arrow.setPickupStatus(pickupStatus);
        if (isFire) {
            arrow.setFireTicks(Integer.MAX_VALUE);
        }
        return arrow;
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.util.checkForNinjaMastersBow(event.getBow())) {
            player.sendMessage("\u00a7cYou need to use LEFT CLICK to shoot this.");
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.util.checkForNinjaMastersBow(player.getInventory().getItemInMainHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.ninjamastersbow.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.ninjamastersbow.use\u00a73.");
            return;
        }
        ItemMeta im = player.getInventory().getItemInMainHand().getItemMeta();
        double damageValue = 2.0 + (im.hasEnchant(Enchantment.POWER) ? 0.5 : 0.0) + (double)im.getEnchantLevel(Enchantment.POWER) * 0.5;
        boolean isFire = im.hasEnchant(Enchantment.FLAME);
        boolean hasInfinity = im.hasEnchant(Enchantment.INFINITY);
        int punchValue = im.getEnchantLevel(Enchantment.PUNCH);
        if (player.getGameMode() != GameMode.CREATIVE) {
            if (!player.getInventory().contains(Material.ARROW)) {
                return;
            }
            if (!hasInfinity) {
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.ARROW, 1)});
            }
        }
        Location eyeLoc = player.getEyeLocation();
        Vector mainDirection = eyeLoc.getDirection();
        double mainYaw = Math.atan2(mainDirection.getZ(), mainDirection.getX());
        double r = Math.sqrt(mainDirection.getX() * mainDirection.getX() + mainDirection.getZ() * mainDirection.getZ());
        double mainPitch = Math.atan2(mainDirection.getY(), r);
        for (int deltaPitch = -2; deltaPitch <= 2; ++deltaPitch) {
            double pitch = mainPitch + (double)deltaPitch * 0.17453292519943295;
            for (int deltaYaw = -2; deltaYaw <= 2; ++deltaYaw) {
                double yaw = mainYaw + (double)deltaYaw * 0.17453292519943295;
                Vector direction = new Vector(Math.cos(pitch) * Math.cos(yaw), Math.sin(pitch), Math.cos(pitch) * Math.sin(yaw));
                Arrow arrow = this.spawnArrow(eyeLoc.getWorld(), eyeLoc.clone().add(direction.clone().multiply(0.15)), direction, 3.0, 0.0, damageValue, punchValue, isFire, player, AbstractArrow.PickupStatus.DISALLOWED);
                arrow.setCritical(deltaPitch == 0 && deltaYaw == 0);
            }
        }
    }
}

