/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.Exodus;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class ExodusItemListener
implements Listener {
    private Map<UUID, Boolean> cooldown = new HashMap<UUID, Boolean>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public ExodusItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    public void doExodusHeal(final Player player) {
        if (this.cooldown.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            PotionEffect effect = new PotionEffect(PotionEffectType.REGENERATION, 60, 1, true);
            player.addPotionEffect(effect);
            this.cooldown.put(player.getUniqueId(), false);
            new BukkitRunnable(){

                public void run() {
                    ExodusItemListener.this.cooldown.put(player.getUniqueId(), true);
                }
            }.runTaskLater((Plugin)this.plugin, 80L);
        }
    }

    @EventHandler
    public void onDamageByEntityPlayer(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (!this.util.checkForExodus(player.getInventory().getHelmet())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.exodus.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.exodus.use\u00a73.");
            return;
        }
        this.doExodusHeal(player);
    }

    @EventHandler
    public void onDamageByEntityProjectile(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)event.getDamager();
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        if (!this.util.checkForExodus(player.getInventory().getHelmet())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.exodus.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.exodus.use\u00a73.");
            return;
        }
        this.doExodusHeal(player);
    }
}

