/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.AtomBomb;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class AtomItemListener
implements Listener {
    private boolean globalCooldownLocked;
    private final WeaponMasterMain plugin;
    private final Util util;
    private final Random rnd = new Random();

    public AtomItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
        this.globalCooldownLocked = false;
    }

    public void spawnVein(Location loc, Material type, float size, int limitDepth, Random rnd) {
        if (loc.getBlock().getType().getBlastResistance() >= 20.0f) {
            return;
        }
        if (loc.getBlock().getType() == Material.AIR) {
            return;
        }
        loc.getBlock().setType(type);
        if (--limitDepth == 0) {
            return;
        }
        if (rnd.nextFloat() < size) {
            this.spawnVein(loc.clone().add(1.0, 0.0, 0.0), type, size, limitDepth, rnd);
        }
        if (rnd.nextFloat() < size) {
            this.spawnVein(loc.clone().add(-1.0, 0.0, 0.0), type, size, limitDepth, rnd);
        }
        if (rnd.nextFloat() < size) {
            this.spawnVein(loc.clone().add(0.0, 1.0, 0.0), type, size, limitDepth, rnd);
        }
        if (rnd.nextFloat() < size) {
            this.spawnVein(loc.clone().add(0.0, -1.0, 0.0), type, size, limitDepth, rnd);
        }
        if (rnd.nextFloat() < size) {
            this.spawnVein(loc.clone().add(0.0, 0.0, 1.0), type, size, limitDepth, rnd);
        }
        if (rnd.nextFloat() < size) {
            this.spawnVein(loc.clone().add(0.0, 0.0, -1.0), type, size, limitDepth, rnd);
        }
    }

    public float getCustomBlastResistance(Material mat) {
        float blastRes = mat.getBlastResistance();
        if (blastRes == 1200.0f) {
            return 20.0f;
        }
        if (blastRes == 100.0f) {
            return 9.0f;
        }
        return blastRes;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        final Player player = event.getPlayer();
        if (!this.util.checkForAtomBomb(event.getItemInHand())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.atombomb.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.atombomb.use\u00a73.");
            return;
        }
        if (this.plugin.getConfig().getBoolean("atomBomb.disable")) {
            player.sendMessage("\u00a7cDue to the destructive nature and lag caused by this item, this weapon is disabled by default.");
            player.sendMessage("\u00a7cIf you wish to use this item, go to config.yml and set atomBomb.disabled to false.");
            return;
        }
        if (this.plugin.getConfig().getBoolean("atomBomb.enforceGlobalCooldown") && this.globalCooldownLocked) {
            player.sendMessage("\u00a7cDue to the lag caused by this item, it is currently on global cooldown.");
            return;
        }
        if (event.getBlockAgainst().getType() != Material.REDSTONE_BLOCK) {
            player.sendMessage("\u00a7cYou must place it on a redstone block!");
            event.setCancelled(true);
            return;
        }
        this.globalCooldownLocked = true;
        final Location at = event.getBlock().getLocation();
        final int NUMBER_RAYS = 1100000;
        final int RAYS_PER_TICK = 2400;
        final float EXPLOSION_POWER = 44.0f;
        double GOLDEN_ANGLE = 3.88322207745093;
        player.sendMessage("\u00a7c[D] \u00a77Precomputing XYZ tables!");
        final double[] xTable = new double[NUMBER_RAYS];
        final double[] yTable = new double[NUMBER_RAYS];
        final double[] zTable = new double[NUMBER_RAYS];
        for (int i = 0; i < NUMBER_RAYS; ++i) {
            double z_hat;
            double y_hat = 1.0 - 2.0 * ((double)i / (double)(NUMBER_RAYS - 1));
            double radius = Math.sqrt(1.0 - y_hat * y_hat);
            double theta = GOLDEN_ANGLE * (double)i;
            double x_hat = Math.cos(theta) * radius;
            double magnitudeSquared = x_hat * x_hat + y_hat * y_hat + (z_hat = Math.sin(theta) * radius) * z_hat;
            if (magnitudeSquared > 1.001 || magnitudeSquared < 0.999) {
                player.sendMessage(String.format("\u00a77Invalid ray! number %d: had x=%.6f y=%.6f z=%.6f (mag %.5f)", i, x_hat, y_hat, z_hat, magnitudeSquared));
            }
            xTable[i] = x_hat;
            yTable[i] = y_hat;
            zTable[i] = z_hat;
        }
        player.sendMessage("\u00a7c[D] \u00a77Done with XYZ tables!");
        new BukkitRunnable(){
            int rayNumber = 0;

            public void run() {
                for (int i = 0; i < RAYS_PER_TICK; ++i) {
                    if (this.rayNumber == NUMBER_RAYS) {
                        player.sendMessage("\u00a76[!] \u00a73You have successfully levelled the landscape.");
                        new BukkitRunnable(){

                            public void run() {
                                AtomItemListener.this.globalCooldownLocked = false;
                            }
                        }.runTaskLater((Plugin)AtomItemListener.this.plugin, 400L);
                        this.cancel();
                        return;
                    }
                    Vector rayStep = new Vector(xTable[this.rayNumber] * 0.6, yTable[this.rayNumber] * 0.6, zTable[this.rayNumber] * 0.6);
                    Location loc = at.clone();
                    float rayPower = EXPLOSION_POWER * (0.8f + 0.4f * AtomItemListener.this.rnd.nextFloat());
                    int worldHeightTop = loc.getWorld().getMaxHeight() + 2;
                    int worldHeightBottom = loc.getWorld().getMinHeight() - 2;
                    while (loc.getBlockY() <= worldHeightTop && loc.getBlockY() >= worldHeightBottom) {
                        rayPower -= 0.45f;
                        if (loc.getBlock().getType() != Material.AIR) {
                            rayPower -= (AtomItemListener.this.getCustomBlastResistance(loc.getBlock().getType()) + 0.6f) * 0.6f;
                        }
                        if (rayPower <= 0.0f) {
                            if (!(rayPower >= -10.0f) || loc.getBlock().getType() == Material.AIR) break;
                            float f = AtomItemListener.this.rnd.nextFloat();
                            if (f < 0.001f) {
                                loc.getBlock().setType(Material.COBBLESTONE);
                            } else if (f < 0.0022f) {
                                AtomItemListener.this.spawnVein(loc, Material.COBBLED_DEEPSLATE, 0.2f, 2, AtomItemListener.this.rnd);
                            } else if (f < 0.0032f) {
                                loc.getBlock().setType(Material.COBWEB);
                            } else if (f < 0.0036f) {
                                AtomItemListener.this.spawnVein(loc, Material.OBSIDIAN, 0.1f, 2, AtomItemListener.this.rnd);
                            } else if (f < 0.0065f) {
                                loc.getBlock().setType(Material.FIRE);
                            }
                            if (!((double)f > 0.997) || loc.getBlock().getType() != Material.COAL_ORE) break;
                            AtomItemListener.this.spawnVein(loc, Material.DEEPSLATE_DIAMOND_ORE, 0.45f, 4, AtomItemListener.this.rnd);
                            break;
                        }
                        loc.getBlock().setType(Material.AIR, false);
                        loc = loc.add(rayStep);
                    }
                    ++this.rayNumber;
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

