/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.mainitems.Ares;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import io.github.greatericontop.weaponmaster.utils.TrueDamageHelper;
import io.github.greatericontop.weaponmaster.utils.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;

public class AresItemListener
implements Listener {
    private final Set<UUID> arrows = new HashSet<UUID>();
    private final WeaponMasterMain plugin;
    private final Util util;

    public AresItemListener(WeaponMasterMain plugin) {
        this.plugin = plugin;
        this.util = new Util(plugin);
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!this.util.checkForAres(event.getBow())) {
            return;
        }
        if (!player.hasPermission("weaponmaster.ares.use")) {
            player.sendMessage("\u00a73Sorry, you cannot use this item yet. You need the permission \u00a74weaponmaster.artemisbow.use\u00a73.");
            return;
        }
        if ((double)event.getForce() < 0.99) {
            player.sendMessage("\u00a77The sky strike requires a fully charged shot!");
            return;
        }
        this.arrows.add(event.getProjectile().getUniqueId());
    }

    @EventHandler
    public void onArrowHit(EntityDamageByEntityEvent event) {
        if (!this.arrows.contains(event.getDamager().getUniqueId())) {
            return;
        }
        if (event.getEntity() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)event.getEntity();
            TrueDamageHelper.dealTrueDamage(target, 2.0);
            target.getWorld().strikeLightningEffect(target.getLocation());
        }
        this.arrows.remove(event.getDamager().getUniqueId());
    }
}

