/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.weaponmaster.dragondescent;

import io.github.greatericontop.weaponmaster.WeaponMasterMain;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DescentCommand
implements CommandExecutor {
    private final int INVENTORY_SIZE = 54;
    private final WeaponMasterMain plugin;

    public DescentCommand(WeaponMasterMain plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cPlayers only, sorry!");
            return true;
        }
        Player player = (Player)sender;
        this.openInventory(player);
        return true;
    }

    public void openInventory(Player player) {
        this.plugin.descent.updateShards(player.getUniqueId());
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)this.plugin.descent.DESCENT_GUI_NAME);
        this.addItems(player, gui, this.plugin.descent.getShards(player.getUniqueId()), this.plugin.descent.getDragonPower(player.getUniqueId()), this.plugin.descent.getPrice(this.plugin.descent.getPurchases(player.getUniqueId()) + 1));
        player.openInventory(gui);
    }

    private void addItems(Player player, Inventory gui, int shardCount, int dragonPowerCount, int price) {
        for (int i = 0; i < 54; ++i) {
            gui.setItem(i, new ItemStack(Material.GRAY_STAINED_GLASS_PANE, 1));
        }
        ItemStack shards = this.newItemStack(Material.DIAMOND, 1, false, "\u00a7bShards", "\u00a77You have \u00a7c" + shardCount + "\u00a77 shards.", String.format("\u00a77You need \u00a7b%d \u00a77shards to get", this.plugin.descent.SHARDS_TO_POWER), String.format("\u00a77a \u00a75Dragon Power\u00a77. (\u00a7a%.0f%%\u00a77)", 100.0 * (double)shardCount / (double)this.plugin.descent.SHARDS_TO_POWER));
        gui.setItem(18, shards);
        int displayPowerAmount = Math.min(Math.max(dragonPowerCount, 1), 10);
        ItemStack power = this.newItemStack(Material.DRAGON_HEAD, displayPowerAmount, false, "\u00a75Dragon Power", "\u00a77You have \u00a7c" + dragonPowerCount + " \u00a75Dragon Power\u00a77.", "\u00a77Your next purchase will cost \u00a7b" + price + "\u00a77.");
        gui.setItem(27, power);
        ItemStack allDamageResistance = this.newItemStack("allDamageResistance", Material.DIAMOND_CHESTPLATE, player, (String)null, 1, "%", "\u00a73All Damage Resistance", "\u00a77Reduce all damage taken by 1% every level.");
        ItemStack dragonExtraRNG = this.newItemStack("dragonExtraRNG", Material.BLUE_ORCHID, player, "allDamageResistance", 1.5, "%", "\u00a73Dragon Extra RNG Drops", "\u00a77Receive 1.5% more chance to get dragon drops every level.");
        ItemStack extraAttackSpeed = this.newItemStack("extraAttackSpeed", Material.GOLDEN_AXE, player, "dragonExtraRNG", 2, "%", "\u00a73Extra Attack Speed", "\u00a77Increase attack speed by 2% every level.");
        ItemStack mightyStrength = this.newItemStack("mightyStrength", Material.STONE_HOE, player, "extraAttackSpeed", 0.1, "%", "\u00a73Mighty Strength", "\u00a77Gain a chance to get 5s of Strength I whenever hit.", "\u00a77+0.1% every level");
        ItemStack vitality = this.newItemStack("vitality", Material.BLAZE_POWDER, player, "mightyStrength", 1, "s", "\u00a73Vitality", "\u00a77Gain Resistance and Fire Resistance for every kill.", "\u00a77+1s every level");
        ItemStack strongAttacks = this.newItemStack("strongAttacks", Material.IRON_SWORD, player, "vitality", 1, "%", "\u00a73Strong Attacks", "\u00a77Increase attack damage by 1% every level.");
        ItemStack heartbleed = this.newItemStack("heartbleed", Material.REDSTONE, player, "extraAttackSpeed", 20, "%", "\u00a73Heartbleed", "\u00a77Gain a 20% chance every level to regenerate 1 HP when", "\u00a77killing any entity. (2 second cooldown)");
        ItemStack shardSeeker = this.newItemStack("shardSeeker", Material.DIAMOND_BLOCK, player, "heartbleed", 2.5, "%", "\u00a73Shard Seeker", "\u00a77Gain 2.5% more shards every level.");
        ItemStack shieldedArmor = this.newItemStack("shieldedArmor", Material.SHIELD, player, "shardSeeker", 1.5, "%", "\u00a73Shielded Armor", "\u00a77Your armor will take less durability and last longer.", "\u00a77Your armor takes 1.5% less durability damage per level.");
        ItemStack silkyTouch = this.newItemStack("silkyTouch", Material.COBWEB, player, "shieldedArmor", 0.3, "%", "\u00a73Silky Touch", "\u00a77Gain a 0.3% chance every level to inflict 5s Slowness I", "\u00a77on any damaged entities.");
        ItemStack tougherArmor = this.newItemStack("tougherArmor", Material.NETHERITE_HELMET, player, "dragonExtraRNG", 3, "%", "\u00a73Tougher Armor", "\u00a77Increase armor toughness by 3% every level.");
        ItemStack enhancedEnergy = this.newItemStack("enhancedEnergy", Material.CARROT, player, "tougherArmor", 2, "%", "\u00a73Enhanced Energy", "\u00a77Decrease hunger exhaustion by 2% every level.");
        ItemStack wisdom = this.newItemStack("wisdom", Material.ENCHANTED_BOOK, player, "enhancedEnergy", 5, "%", "\u00a73Wisdom", "\u00a77Gain 5% more XP from orbs every level.");
        ItemStack strongLegs = this.newItemStack("strongLegs", Material.WATER_BUCKET, player, "wisdom", 15, "%", "\u00a73Strong Legs", "\u00a77Take 15% less fall damage every level.");
        ItemStack sicklyTouch = this.newItemStack("sicklyTouch", Material.SPIDER_EYE, player, "strongLegs", 0.3, "%", "\u00a73Sickly Touch", "\u00a77Gain a 0.3% chance every level to inflict 5s Poison I", "\u00a77on any damaged entities.");
        ItemStack witch = this.newItemStack("witch", Material.DRAGON_BREATH, player, "sicklyTouch", 3, "%", "\u00a73Witch", "\u00a77Drinkable potions last 3% longer every level.");
        ItemStack strongArrows = this.newItemStack("strongArrows", Material.CROSSBOW, player, "enhancedEnergy", 1, "%", "\u00a73Strong Arrows", "\u00a77Increase arrow damage by 1% every level.");
        ItemStack grimTouch = this.newItemStack("grimTouch", Material.BONE, player, "strongArrows", 0.3, "%", "\u00a73Grim Touch", "\u00a77Gain a 0.3% chance every level to inflict 5s Weakness I", "\u00a77on any damaged entities.");
        ItemStack reviver = this.newItemStack("reviver", Material.TOTEM_OF_UNDYING, player, "strongLegs", 3, "s", "\u00a73Strong Revive", "\u00a77When reviving, regenerate for 3s longer every level.", "\u00a77A small portion of the time is also converted", "\u00a77to a more potent effect.");
        ItemStack runner = this.newItemStack("runner", Material.SUGAR, player, "witch", 0.8, "%", "\u00a73Runner", "\u00a77Increase movement speed by 0.8% every level.");
        gui.setItem(4, allDamageResistance);
        gui.setItem(13, dragonExtraRNG);
        gui.setItem(14, tougherArmor);
        gui.setItem(15, enhancedEnergy);
        gui.setItem(16, strongArrows);
        gui.setItem(17, grimTouch);
        gui.setItem(20, shardSeeker);
        gui.setItem(21, heartbleed);
        gui.setItem(22, extraAttackSpeed);
        gui.setItem(24, wisdom);
        gui.setItem(29, shieldedArmor);
        gui.setItem(31, mightyStrength);
        gui.setItem(33, strongLegs);
        gui.setItem(34, reviver);
        gui.setItem(38, silkyTouch);
        gui.setItem(40, vitality);
        gui.setItem(42, sicklyTouch);
        gui.setItem(49, strongAttacks);
        gui.setItem(51, witch);
        gui.setItem(52, runner);
    }

    private ItemStack newItemStack(String upgradeKey, Material material, Player player, String prerequisite, double displayMulti, String displaySuffix, String name, String ... lore) {
        String displayText = String.format("\u00a77You have \u00a72%.1f%s\u00a77.", (double)this.plugin.descent.getUpgrade(player, upgradeKey) * displayMulti, displaySuffix);
        return this.newItemStack(upgradeKey, material, player, prerequisite, displayText, name, lore);
    }

    private ItemStack newItemStack(String upgradeKey, Material material, Player player, String prerequisite, int displayMulti, String displaySuffix, String name, String ... lore) {
        String displayText = String.format("\u00a77You have \u00a72%d%s\u00a77.", this.plugin.descent.getUpgrade(player, upgradeKey) * displayMulti, displaySuffix);
        return this.newItemStack(upgradeKey, material, player, prerequisite, displayText, name, lore);
    }

    private ItemStack newItemStack(String upgradeKey, Material material, Player player, String prerequisite, String displayText, String name, String ... lore) {
        if (prerequisite != null && this.plugin.descent.getUpgrade(player, prerequisite) == 0) {
            ItemStack stack = new ItemStack(Material.BARRIER, 1);
            ItemMeta im = stack.getItemMeta();
            im.setDisplayName("\u00a7cLocked!");
            stack.setItemMeta(im);
            return stack;
        }
        int level = this.plugin.descent.getUpgrade(player, upgradeKey);
        lore = Arrays.copyOf(lore, lore.length + 3);
        lore[lore.length - 3] = "";
        lore[lore.length - 2] = String.format("\u00a7fLevel: \u00a7b%d", level);
        lore[lore.length - 1] = displayText;
        boolean isEnchanted = level > 0;
        return this.newItemStack(material, Math.max(level, 1), isEnchanted, name, lore);
    }

    private ItemStack newItemStack(Material material, int amount, boolean enchanted, String name, String ... lore) {
        ItemStack stack = new ItemStack(material, amount);
        ItemMeta im = stack.getItemMeta();
        im.setDisplayName(name);
        im.setLore(Arrays.asList(lore));
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        if (enchanted) {
            im.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, true);
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        stack.setItemMeta(im);
        return stack;
    }
}

