/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatutils.warps;

import io.github.greatericontop.greatutils.GreatUtils;
import io.github.greatericontop.greatutils.util.GreatCommands;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class WarpCommand
implements CommandExecutor,
TabCompleter {
    private final GreatUtils plugin;

    public WarpCommand(GreatUtils plugin) {
        this.plugin = plugin;
    }

    public List<String> getAvailableWarps() {
        return new ArrayList<String>(this.plugin.warpConfig.getConfigurationSection("warps").getKeys(false));
    }

    public boolean warpExists(String warpName) {
        return this.plugin.warpConfig.getString("warps." + warpName) != null;
    }

    public Location loadWarp(String warpName) {
        return (Location)this.plugin.warpConfig.getObject("warps." + warpName, Location.class);
    }

    public void saveWarp(Location location, String warpName) {
        this.plugin.warpConfig.set("warps." + warpName, (Object)location);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String warpName = GreatCommands.argumentString(0, args);
        String subOperation = GreatCommands.argumentString(1, args);
        if (warpName == null) {
            sender.sendMessage("\u00a73Available warps: \u00a7f%s".formatted(String.join((CharSequence)"\u00a77, \u00a7f", this.getAvailableWarps())));
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cPlayers only!");
            return true;
        }
        Player player = (Player)sender;
        if (subOperation == null) {
            if (!this.warpExists(warpName)) {
                player.sendMessage("\u00a7cWarp \u00a7f%s \u00a7cdoes not exist.".formatted(warpName));
                return true;
            }
            player.teleport(this.loadWarp(warpName));
            return true;
        }
        if (subOperation.equalsIgnoreCase("set")) {
            this.saveWarp(player.getLocation(), warpName);
            player.sendMessage("\u00a73Saved warp \u00a7f%s\u00a73.".formatted(warpName));
            return true;
        }
        if (subOperation.equalsIgnoreCase("delete")) {
            this.saveWarp(null, warpName);
            player.sendMessage("\u00a73Deleted warp \u00a7f%s\u00a73.".formatted(warpName));
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], this.getAvailableWarps(), new ArrayList(this.getAvailableWarps().size()));
        }
        if (args.length == 2) {
            return (List)StringUtil.copyPartialMatches((String)args[1], List.of("set", "delete"), new ArrayList(2));
        }
        return null;
    }
}

