/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatutils.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class GreatCommands {
    @Nullable
    public static String argumentString(int i, String[] args) {
        if (args.length <= i) {
            return null;
        }
        return args[i];
    }

    @Nullable
    public static String argumentStringFromChoices(int i, String[] args, String[] choices) {
        if (args.length <= i) {
            return null;
        }
        for (String choice : choices) {
            if (!args[i].equals(choice)) continue;
            return choice;
        }
        return null;
    }

    @Nullable
    public static String argumentStringConsumeRest(int iStart, String[] args) {
        if (args.length <= iStart) {
            return null;
        }
        return String.join((CharSequence)" ", Arrays.copyOfRange(args, iStart, args.length));
    }

    @Nullable
    public static Integer argumentInteger(int i, String[] args) {
        if (args.length <= i) {
            return null;
        }
        try {
            return Integer.parseInt(args[i]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static int[] argumentIntegerConsumeRest(int iStart, String[] args) {
        if (args.length <= iStart) {
            return null;
        }
        int[] result = new int[args.length - iStart];
        for (int argIndex = iStart; argIndex < args.length; ++argIndex) {
            try {
                result[argIndex - iStart] = Integer.parseInt(args[argIndex]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return result;
    }

    @Nullable
    public static Player argumentPlayer(int i, String[] args) {
        if (args.length <= i) {
            return null;
        }
        return Bukkit.getPlayer((String)args[i]);
    }

    @Nullable
    public static Integer argumentTime(int i, String[] args) {
        int multi;
        if (args.length <= i) {
            return null;
        }
        String arg = args[i].toLowerCase();
        switch (arg.charAt(arg.length() - 1)) {
            case 't': {
                multi = 1;
                break;
            }
            case 's': {
                multi = 20;
                break;
            }
            case 'm': {
                multi = 1200;
                break;
            }
            case 'h': {
                multi = 72000;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            return Integer.parseInt(arg.substring(0, arg.length() - 1)) * multi;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static List<String> tabCompleteTime(String arg, String ... paramNames) {
        if (arg.isEmpty()) {
            return List.of(paramNames);
        }
        if (arg.matches("^\\d+$")) {
            return List.of(arg + "t", arg + "s", arg + "m", arg + "h");
        }
        return null;
    }

    public static List<String> tabCompletePlayers(String arg, String ... extraChoices) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String choice : extraChoices) {
            if (!choice.toLowerCase().startsWith(arg.toLowerCase())) continue;
            suggestions.add(choice);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().toLowerCase().startsWith(arg.toLowerCase())) continue;
            suggestions.add(player.getName());
        }
        return suggestions;
    }
}

