/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatutils.kits;

import io.github.greatericontop.greatutils.GreatUtils;
import io.github.greatericontop.greatutils.util.GreatCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class KitCommand
implements CommandExecutor,
TabCompleter {
    private final GreatUtils plugin;

    public KitCommand(GreatUtils plugin) {
        this.plugin = plugin;
    }

    public List<String> getAvailableKits() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : this.plugin.kitConfig.getConfigurationSection("kits").getKeys(false)) {
            if (key.endsWith("~")) continue;
            ret.add(key);
        }
        return ret;
    }

    public boolean kitExists(String kitName) {
        return this.plugin.kitConfig.getString("kits." + kitName) != null;
    }

    public ItemStack[] loadKit(String kitName) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        try {
            yamlConfiguration.loadFromString(this.plugin.kitConfig.getString("kits." + kitName));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return (ItemStack[])((Collection)yamlConfiguration.get("inventory")).toArray(ItemStack[]::new);
    }

    public void saveKit(Player player, String kitName) {
        this.saveKit(player.getInventory().getContents(), kitName);
    }

    public void saveKit(ItemStack[] contents, String kitName) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.set("inventory", (Object)contents);
        this.plugin.kitConfig.set("kits." + kitName, (Object)yamlConfiguration.saveToString());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String kitName = GreatCommands.argumentString(0, args);
        String subOperation = GreatCommands.argumentString(1, args);
        if (kitName == null) {
            sender.sendMessage("\u00a73Available kits: \u00a7f%s".formatted(String.join((CharSequence)"\u00a77, \u00a7f", this.getAvailableKits())));
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cPlayers only!");
            return true;
        }
        Player player = (Player)sender;
        if (subOperation == null) {
            if (!this.kitExists(kitName)) {
                player.sendMessage("\u00a7cKit \u00a7f%s \u00a7cdoes not exist.".formatted(kitName));
                return true;
            }
            ItemStack[] kit = this.loadKit(kitName);
            player.getInventory().setContents(kit);
            player.sendMessage("\u00a73Gave kit \u00a7f%s \u00a73to you.".formatted(kitName));
            return true;
        }
        if (subOperation.equalsIgnoreCase("update")) {
            if (this.kitExists(kitName)) {
                this.saveKit(this.loadKit(kitName), "%s~".formatted(kitName));
            }
            this.saveKit(player, kitName);
            player.sendMessage("\u00a73Saved kit \u00a7f%s\u00a73.".formatted(kitName));
            return true;
        }
        if (subOperation.equalsIgnoreCase("everyone")) {
            ItemStack[] kit = this.loadKit(kitName);
            for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                p.getInventory().setContents(kit);
                p.sendMessage("\u00a7b%s \u00a73gave kit \u00a7f%s \u00a73to you.".formatted(player.getName(), kitName));
            }
            player.sendMessage("\u00a73Gave kit \u00a7f%s \u00a73to \u00a7beveryone\u00a73.".formatted(kitName));
            return true;
        }
        if (subOperation.equalsIgnoreCase("delete")) {
            if (!this.kitExists(kitName) && !kitName.endsWith("~")) {
                player.sendMessage("\u00a7cKit \u00a7f%s \u00a7cdoes not exist.".formatted(kitName));
                return true;
            }
            this.saveKit(this.loadKit(kitName), "%s~".formatted(kitName));
            this.plugin.kitConfig.set("kits." + kitName, null);
            player.sendMessage("\u00a73Deleted kit \u00a7f%s\u00a73.".formatted(kitName));
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], this.getAvailableKits(), new ArrayList(this.getAvailableKits().size()));
        }
        if (args.length == 2) {
            return (List)StringUtil.copyPartialMatches((String)args[1], List.of("update", "everyone", "delete"), new ArrayList(3));
        }
        return null;
    }
}

