/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatutils.commandexecution;

import io.github.greatericontop.greatutils.GreatUtils;
import io.github.greatericontop.greatutils.util.GreatCommands;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ExecTimerCommand
implements CommandExecutor,
TabCompleter {
    private final GreatUtils plugin;

    public ExecTimerCommand(GreatUtils plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(final CommandSender sender, Command command, String label, String[] args) {
        Integer times;
        Integer interval;
        if (args.length < 2) {
            sender.sendMessage("\u00a7cSpecify an interval and a number of times!");
            return false;
        }
        Integer maybeTimes = GreatCommands.argumentInteger(0, args);
        if (maybeTimes == null) {
            interval = GreatCommands.argumentTime(0, args);
            times = GreatCommands.argumentInteger(1, args);
        } else {
            interval = GreatCommands.argumentTime(1, args);
            times = maybeTimes;
        }
        if (times == null || interval == null) {
            sender.sendMessage("\u00a7cEnter a valid interval and number of times!");
            return false;
        }
        if (times <= 0) {
            sender.sendMessage("\u00a7cNumber of times must be positive!");
            return false;
        }
        if (interval <= 0) {
            sender.sendMessage("\u00a7cInterval must be positive!");
            return false;
        }
        final String commandToRun = GreatCommands.argumentStringConsumeRest(2, args);
        if (commandToRun == null) {
            sender.sendMessage("\u00a7cEnter a command!");
            return false;
        }
        BukkitTask bt = new BukkitRunnable(){
            int timesLeft;
            {
                this.timesLeft = times;
            }

            public void run() {
                if (this.timesLeft <= 0) {
                    this.cancel();
                    return;
                }
                Bukkit.dispatchCommand((CommandSender)sender, (String)commandToRun);
                --this.timesLeft;
            }
        }.runTaskTimer((Plugin)this.plugin, (long)interval.intValue(), (long)interval.intValue());
        this.plugin.commandTaskManager.put(sender, bt, commandToRun);
        sender.sendMessage(String.format("\u00a73Running \u00a7f%s \u00a7bx%d \u00a73every \u00a7f%d \u00a73ticks. \u00a77(#%d)", commandToRun, times, interval, bt.getTaskId()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return GreatCommands.tabCompleteTime(args[0], "<number of times>", "<interval>");
        }
        if (args.length == 2) {
            if (GreatCommands.argumentInteger(0, args) != null) {
                return GreatCommands.tabCompleteTime(args[1], "<interval>");
            }
            return List.of("<number of times>");
        }
        return List.of("<command...>");
    }
}

