/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatutils.commandexecution;

import io.github.greatericontop.greatutils.GreatUtils;
import io.github.greatericontop.greatutils.util.GreatCommands;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ExecLaterRNGCommand
implements CommandExecutor,
TabCompleter {
    private final Random rnd;
    private final GreatUtils plugin;

    public ExecLaterRNGCommand(GreatUtils plugin) {
        this.plugin = plugin;
        this.rnd = new Random();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Integer delayMin = GreatCommands.argumentTime(0, args);
        Integer delayMax = GreatCommands.argumentTime(1, args);
        if (delayMin == null || delayMin < 0 || delayMax == null || delayMax < 0) {
            sender.sendMessage("\u00a7cInvalid delay. Examples: 20t, 1s, 5m");
            return false;
        }
        if (delayMax < delayMin) {
            sender.sendMessage("\u00a7cMax delay must be greater than or equal to min delay!");
            return false;
        }
        String commandToRun = GreatCommands.argumentStringConsumeRest(2, args);
        if (commandToRun == null) {
            sender.sendMessage("\u00a7cEnter a command!");
            return false;
        }
        int delay = this.rnd.nextInt(delayMin, delayMax + 1);
        BukkitTask bt = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> Bukkit.dispatchCommand((CommandSender)sender, (String)commandToRun), (long)delay);
        this.plugin.commandTaskManager.put(sender, bt, commandToRun);
        sender.sendMessage(String.format("\u00a73Running \u00a7f%s \u00a73in \u00a7f%d \u00a73ticks. \u00a77(#%d)", commandToRun, delay, bt.getTaskId()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return GreatCommands.tabCompleteTime(args[0], "<min delay>");
        }
        if (args.length == 2) {
            return GreatCommands.tabCompleteTime(args[1], "<max delay>");
        }
        return List.of("<command...>");
    }
}

