/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatutils.commandexecution;

import io.github.greatericontop.greatutils.GreatUtils;
import io.github.greatericontop.greatutils.util.GreatCommands;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ExecLaterCommand
implements CommandExecutor,
TabCompleter {
    private final GreatUtils plugin;

    public ExecLaterCommand(GreatUtils plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Integer delay = GreatCommands.argumentTime(0, args);
        if (delay == null || delay < 0) {
            sender.sendMessage("\u00a7cInvalid delay. Examples: 20t, 1s, 5m");
            return false;
        }
        String commandToRun = GreatCommands.argumentStringConsumeRest(1, args);
        if (commandToRun == null) {
            sender.sendMessage("\u00a7cEnter a command!");
            return false;
        }
        BukkitTask bt = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> Bukkit.dispatchCommand((CommandSender)sender, (String)commandToRun), (long)delay.intValue());
        this.plugin.commandTaskManager.put(sender, bt, commandToRun);
        sender.sendMessage(String.format("\u00a73Running \u00a7f%s \u00a73in \u00a7f%d \u00a73ticks. \u00a77(#%d)", commandToRun, delay, bt.getTaskId()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return GreatCommands.tabCompleteTime(args[0], "<delay>");
        }
        return List.of("<command...>");
    }
}

