/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatutils.commandexecution;

import io.github.greatericontop.greatutils.GreatUtils;
import io.github.greatericontop.greatutils.commandexecution.CommandTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

public class CommandTaskManager {
    public final Map<UUID, List<CommandTask>> commandTasks = new HashMap<UUID, List<CommandTask>>();
    private final GreatUtils plugin;

    public CommandTaskManager(GreatUtils plugin) {
        this.plugin = plugin;
    }

    public void put(CommandSender sender, BukkitTask task, String commandStr) {
        UUID uuid;
        if (sender instanceof Player) {
            Player p = (Player)sender;
            uuid = p.getUniqueId();
        } else if (sender instanceof ConsoleCommandSender) {
            uuid = UUID.fromString("00000000-0000-0000-0000-000000000000");
        } else {
            return;
        }
        CommandTask commandTask = new CommandTask(commandStr, task.getTaskId());
        if (!this.commandTasks.containsKey(uuid)) {
            this.commandTasks.put(uuid, new ArrayList());
        }
        this.commandTasks.get(uuid).add(commandTask);
    }

    @Nullable
    public List<CommandTask> get(CommandSender sender) {
        UUID uuid;
        if (sender instanceof Player) {
            Player p = (Player)sender;
            uuid = p.getUniqueId();
        } else if (sender instanceof ConsoleCommandSender) {
            uuid = UUID.fromString("00000000-0000-0000-0000-000000000000");
        } else {
            return null;
        }
        return this.prune(this.commandTasks.get(uuid));
    }

    @Nullable
    private List<CommandTask> prune(@Nullable List<CommandTask> tasks) {
        if (tasks == null) {
            return null;
        }
        HashSet<Integer> activeTaskIds = new HashSet<Integer>();
        for (BukkitTask bt : Bukkit.getScheduler().getPendingTasks()) {
            activeTaskIds.add(bt.getTaskId());
        }
        for (int i = tasks.size() - 1; i >= 0; --i) {
            if (activeTaskIds.contains(tasks.get(i).taskId())) continue;
            tasks.remove(i);
        }
        return tasks;
    }
}

