/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatutils.commandexecution;

import io.github.greatericontop.greatutils.GreatUtils;
import io.github.greatericontop.greatutils.commandexecution.CommandTask;
import io.github.greatericontop.greatutils.util.GreatCommands;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class CancelTaskCommand
implements CommandExecutor,
TabCompleter {
    private final GreatUtils plugin;

    public CancelTaskCommand(GreatUtils plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1) {
            sender.sendMessage("\u00a7cSpecify what to cancel!");
            return false;
        }
        if (args[0].equalsIgnoreCase("all")) {
            List<CommandTask> tasks = this.plugin.commandTaskManager.get(sender);
            if (tasks == null || tasks.isEmpty()) {
                sender.sendMessage("\u00a7cYou have nothing to cancel!");
                return true;
            }
            for (CommandTask task : tasks) {
                Bukkit.getScheduler().cancelTask(task.taskId());
            }
            sender.sendMessage("\u00a73Cancelled all your tasks!");
            return true;
        }
        int[] taskIds = GreatCommands.argumentIntegerConsumeRest(0, args);
        if (taskIds == null) {
            sender.sendMessage("\u00a7cTask IDs must be integers!");
            return false;
        }
        for (int taskId : taskIds) {
            Bukkit.getScheduler().cancelTask(taskId);
            sender.sendMessage("\u00a73Cancelled task \u00a7f%d\u00a73.".formatted(taskId));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return List.of("<task number>", "all");
        }
        return List.of("<another task number>");
    }
}

