/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.mechanics;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import java.util.List;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.projectiles.ProjectileSource;

public class UHCCustomDamage
implements Listener {
    private final GreatUHCMain plugin;

    public UHCCustomDamage(GreatUHCMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamageNonPlayers(EntityDamageEvent event) {
        if (event.getEntity() instanceof Mob) {
            event.setDamage(event.getDamage() * 1.25);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamageSurvivalism(EntityDamageEvent event) {
        if (!this.plugin.uhcSurvivalism) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.isCancelled()) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause == EntityDamageEvent.DamageCause.VOID || cause == EntityDamageEvent.DamageCause.ENTITY_ATTACK || cause == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK || cause == EntityDamageEvent.DamageCause.PROJECTILE) {
            return;
        }
        if (cause == EntityDamageEvent.DamageCause.MAGIC || cause == EntityDamageEvent.DamageCause.POISON || cause == EntityDamageEvent.DamageCause.WITHER) {
            this.plugin.debugMsg(player, "survivalism: potion damage cause, slightly reducing damage", new Object[0]);
            event.setDamage(event.getDamage() * 0.725);
            return;
        }
        if (cause == EntityDamageEvent.DamageCause.LAVA || cause == EntityDamageEvent.DamageCause.FIRE || cause == EntityDamageEvent.DamageCause.FIRE_TICK) {
            this.plugin.debugMsg(player, "survivalism: fire damage cause, slightly reducing damage", new Object[0]);
            event.setDamage(event.getDamage() * 0.65);
            return;
        }
        this.plugin.debugMsg(player, "survivalism: other damage cause, reducing damage", new Object[0]);
        event.setDamage(event.getDamage() * 0.4);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDamageByEntitySurvivalism(EntityDamageByEntityEvent event) {
        if (!this.plugin.uhcSurvivalism) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.isCancelled()) {
            return;
        }
        Entity damagingEntity = event.getDamager();
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause == EntityDamageEvent.DamageCause.ENTITY_ATTACK || cause == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) {
            if (!(damagingEntity instanceof Player)) {
                this.plugin.debugMsg(player, "survivalism: entity attack, reducing damage", new Object[0]);
                event.setDamage(event.getDamage() * 0.4);
            }
            return;
        }
        if (cause == EntityDamageEvent.DamageCause.PROJECTILE) {
            ProjectileSource shooter = ((Projectile)damagingEntity).getShooter();
            if (!(shooter instanceof Player)) {
                this.plugin.debugMsg(player, "survivalism: projectile hit, reducing damage", new Object[0]);
                event.setDamage(event.getDamage() * 0.4);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDamageProtection(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.isCancelled()) {
            return;
        }
        int totalProtectionLevel = 0;
        ItemStack helmet = player.getInventory().getHelmet();
        totalProtectionLevel += helmet != null ? helmet.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL) : 0;
        ItemStack chestplate = player.getInventory().getChestplate();
        totalProtectionLevel += chestplate != null ? chestplate.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL) : 0;
        ItemStack leggings = player.getInventory().getLeggings();
        totalProtectionLevel += leggings != null ? leggings.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL) : 0;
        ItemStack boots = player.getInventory().getBoots();
        if ((totalProtectionLevel += boots != null ? boots.getEnchantmentLevel(Enchantment.PROTECTION_ENVIRONMENTAL) : 0) > 0) {
            totalProtectionLevel = Math.min(totalProtectionLevel, 18);
            double damageMultiplier = Math.pow(0.9825, totalProtectionLevel);
            this.plugin.debugMsg(player, "protection levels: %d | reduction: %.3f", totalProtectionLevel, 1.0 - damageMultiplier);
            event.setDamage(event.getDamage() * damageMultiplier);
        }
        event.setDamage(event.getDamage() * 0.95);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDamageSharpness(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.isCancelled()) {
            return;
        }
        ItemStack attackingItem = player.getInventory().getItemInMainHand();
        int sharpnessLevel = attackingItem.getEnchantmentLevel(Enchantment.DAMAGE_ALL);
        if (sharpnessLevel > 0) {
            double bonusDamage = (double)sharpnessLevel * 0.75 - 0.5;
            double adjustedBonusDamage = bonusDamage * (double)player.getCooledAttackStrength(0.0f);
            event.setDamage(event.getDamage() + adjustedBonusDamage);
            this.plugin.debugMsg(player, "sharpness buff +%.2f, new damage \u00a7f%.2f", adjustedBonusDamage, event.getDamage());
        }
    }

    @EventHandler
    public void onShootBow(EntityShootBowEvent event) {
        ItemMeta im;
        ItemStack bow;
        Entity entity = event.getProjectile();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow projectile = (AbstractArrow)entity;
        double multi = 0.8;
        if (event.getEntity() instanceof Player && (bow = event.getBow()) != null && (im = bow.getItemMeta()) != null) {
            List lore = im.getLore();
            if (lore != null && ((String)lore.get(0)).equals("Undead")) {
                multi += 0.2;
            }
            if (lore != null && ((String)lore.get(0)).equals("id: ARTEMIS_BOW")) {
                multi += 0.1;
            }
        }
        projectile.setDamage(projectile.getDamage() * multi);
    }
}

