/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.mechanics;

import java.util.Random;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerDeathListener
implements Listener {
    private final Random random = new Random();

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        player.setGameMode(GameMode.SPECTATOR);
        event.setDeathMessage("\u00a7c" + event.getDeathMessage());
        player.getWorld().strikeLightningEffect(player.getLocation());
        event.getDrops().add(new ItemStack(Material.GOLD_INGOT, 2 + this.random.nextInt(4)));
        Player killer = event.getPlayer().getKiller();
        if (killer != null) {
            killer.sendMessage(String.format("\u00a7aYou killed \u00a7f%s\u00a7a!", player.getName()));
            killer.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 100, 0));
        }
    }
}

