/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.mechanics;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import io.github.greatericontop.greatuhc.game.GameManager;
import io.github.greatericontop.greatuhc.util.TrueDamageHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class GracePeriodProtectionListener
implements Listener {
    private final Set<UUID> affectedPlayers = new HashSet<UUID>();
    private final GameManager gameManager;

    public GracePeriodProtectionListener(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMeleeDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (this.gameManager.getCurrentPhase() == GameManager.GamePhase.GRACE_PERIOD) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot damage players during the grace period!");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerProjectileDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)entity;
        ProjectileSource projectileSource = projectile.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (this.gameManager.getCurrentPhase() == GameManager.GamePhase.GRACE_PERIOD) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot damage players during the grace period!");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerTakeEnvironmentalDamage(EntityDamageEvent event) {
        EntityDamageByEntityEvent event1;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        if (this.gameManager.getCurrentPhase() != GameManager.GamePhase.GRACE_PERIOD || !this.gameManager.getPlugin().getConfig().getBoolean("grace_period_extra_protection")) {
            return;
        }
        if (event instanceof EntityDamageByEntityEvent && ((event1 = (EntityDamageByEntityEvent)event).getDamager() instanceof Projectile || event1.getDamager() instanceof LivingEntity)) {
            return;
        }
        for (Entity e : victim.getNearbyEntities(1.5, 3.0, 1.5)) {
            Player nearbyPlayer;
            if (!(e instanceof Player) || (nearbyPlayer = (Player)e) == victim || this.affectedPlayers.contains(nearbyPlayer.getUniqueId())) continue;
            this.affectedPlayers.add(nearbyPlayer.getUniqueId());
            TrueDamageHelper.dealTrueDamage((LivingEntity)nearbyPlayer, event.getFinalDamage());
            nearbyPlayer.sendMessage("\u00a7cYou are too close to this player!");
        }
    }

    public void registerClearingRunnable(GreatUHCMain plugin) {
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this.affectedPlayers::clear, 1L, 1L);
    }
}

