/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.mechanics;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class DiamondSpreading
implements Listener {
    private static final int[] dx = new int[]{1, -1, 0, 0, 0, 0};
    private static final int[] dy = new int[]{0, 0, 1, -1, 0, 0};
    private static final int[] dz = new int[]{0, 0, 0, 0, 1, -1};
    private final Random random = new Random();

    public boolean isExposed(Location loc) {
        for (int i = 0; i < 6; ++i) {
            Material mat = loc.clone().add((double)dx[i], (double)dy[i], (double)dz[i]).getBlock().getType();
            if (!mat.isAir() && mat.isSolid()) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Material blockType = event.getBlock().getType();
        if (blockType != Material.DIAMOND_ORE && blockType != Material.DEEPSLATE_DIAMOND_ORE) {
            return;
        }
        if (Math.random() >= 0.24) {
            return;
        }
        Location loc = event.getBlock().getLocation();
        int offset = this.random.nextInt(6);
        loc.add((double)dx[offset], (double)dy[offset], (double)dz[offset]);
        if (this.isExposed(loc)) {
            return;
        }
        Material mat = loc.getBlock().getType();
        if (mat == Material.STONE || mat == Material.ANDESITE || mat == Material.DIORITE || mat == Material.GRANITE) {
            loc.getBlock().setType(Material.DIAMOND_ORE);
        } else if (mat == Material.DEEPSLATE || mat == Material.TUFF) {
            loc.getBlock().setType(Material.DEEPSLATE_DIAMOND_ORE);
        }
    }
}

