/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.mechanics;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CustomHealingListener
implements Listener {
    private final Map<UUID, Boolean> headEatCooldown = new HashMap<UUID, Boolean>();
    private final GreatUHCMain plugin;

    public CustomHealingListener(GreatUHCMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        if (event.getEntity().getType() == EntityType.PLAYER) {
            Player victim = (Player)event.getEntity();
            ItemStack head = new ItemStack(Material.PLAYER_HEAD, this.plugin.uhcDoubleHeads ? 2 : 1);
            SkullMeta im = (SkullMeta)head.getItemMeta();
            im.setOwningPlayer((OfflinePlayer)victim);
            im.setDisplayName(String.format("\u00a7c%s\u00a77's \u00a7bHead \u00a7e\u00a7lRIGHT CLICK", victim.getName()));
            im.addEnchant(Enchantment.LUCK, 1, true);
            head.setItemMeta((ItemMeta)im);
            victim.getWorld().dropItemNaturally(victim.getLocation(), head);
        }
    }

    @EventHandler
    public void onClickHead(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.PLAYER_HEAD) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
        }
        if (this.headEatCooldown.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        ItemMeta im = item.getItemMeta();
        if (im != null && im.getPersistentDataContainer().has(new NamespacedKey("uhc", "golden_head"))) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 120, 3));
            player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 4800, 0));
            player.sendMessage("\u00a7aYou ate a \u00a76Golden \u00a7aHead!");
        } else {
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 200, 1));
            player.sendMessage("\u00a7aYou ate a player head!");
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 500, 1));
        if (this.plugin.uhcPowerfulHeads) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 400, 0));
        }
        item.setAmount(item.getAmount() - 1);
        this.headEatCooldown.put(player.getUniqueId(), true);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.headEatCooldown.put(player.getUniqueId(), false), 10L);
    }

    @EventHandler
    public void onRightClickCorn(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.GOLDEN_CARROT) {
            return;
        }
        if (item.getItemMeta() == null || item.getItemMeta().getLore() == null) {
            return;
        }
        if (((String)item.getItemMeta().getLore().get(0)).equals("Corn")) {
            if (this.headEatCooldown.getOrDefault(player.getUniqueId(), false).booleanValue()) {
                return;
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 160, 1));
            player.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 1200, 0));
            item.setAmount(item.getAmount() - 1);
            this.headEatCooldown.put(player.getUniqueId(), true);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.headEatCooldown.put(player.getUniqueId(), false), 10L);
        }
    }

    @EventHandler
    public void onEat(PlayerItemConsumeEvent event) {
        Material foodType = event.getItem().getType();
        if (foodType == Material.GOLDEN_APPLE) {
            event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 100, 2));
            event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 4800, 0));
        }
        if (foodType == Material.ENCHANTED_GOLDEN_APPLE) {
            event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 600, 4));
            event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 4800, 3));
        }
    }
}

