/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.mechanics;

import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class AntiAnvil
implements Listener {
    private static final NamespacedKey NO_ANVIL_KEY = new NamespacedKey("uhc", "noanvil");

    @EventHandler(priority=EventPriority.HIGH)
    public void onAnvilSource(PrepareAnvilEvent event) {
        ItemStack source = event.getInventory().getItem(0);
        ItemStack sacrifice = event.getInventory().getItem(1);
        if (source == null) {
            return;
        }
        if (sacrifice == null) {
            return;
        }
        ItemMeta imSource = source.getItemMeta();
        ItemMeta imSacrifice = sacrifice.getItemMeta();
        if (this.isAnvilDisabled(imSource) || this.isAnvilDisabled(imSacrifice)) {
            event.setResult(null);
            ((HumanEntity)event.getViewers().get(0)).sendMessage("\u00a7cYou can't use this in an anvil!");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEnchantingTable(PrepareItemEnchantEvent event) {
        ItemMeta im = event.getItem().getItemMeta();
        if (this.isAnvilDisabled(im)) {
            event.setCancelled(true);
            ((HumanEntity)event.getViewers().get(0)).sendMessage("\u00a7cYou can't manually enchant this item!");
        }
    }

    private boolean isAnvilDisabled(ItemMeta im) {
        return im != null && im.getPersistentDataContainer().has(NO_ANVIL_KEY, PersistentDataType.INTEGER);
    }

    public static void disallowAnvil(ItemMeta im) {
        im.getPersistentDataContainer().set(NO_ANVIL_KEY, PersistentDataType.INTEGER, (Object)1);
    }
}

