/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.mechanics;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class AbsorptionEffectFix
implements Listener {
    private final GreatUHCMain plugin;

    public AbsorptionEffectFix(GreatUHCMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onAbsorptionEffectAdd(final EntityPotionEffectEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        final Player player = (Player)entity;
        if (event.getAction() == EntityPotionEffectEvent.Action.CHANGED && event.getNewEffect().getType().getId() == PotionEffectType.ABSORPTION.getId()) {
            if (event.getOldEffect().getAmplifier() > event.getNewEffect().getAmplifier()) {
                double healthNewEffectShouldGive = 4.0 * (double)(event.getNewEffect().getAmplifier() + 1);
                if (player.getAbsorptionAmount() < healthNewEffectShouldGive) {
                    player.removePotionEffect(PotionEffectType.ABSORPTION);
                    new BukkitRunnable(){

                        public void run() {
                            player.addPotionEffect(event.getNewEffect());
                        }
                    }.runTaskLater((Plugin)this.plugin, 1L);
                } else {
                    event.setCancelled(true);
                }
            } else if (event.getOldEffect().getAmplifier() == event.getNewEffect().getAmplifier()) {
                double healthNewEffectShouldGive = 4.0 * (double)(event.getNewEffect().getAmplifier() + 1);
                if (player.getAbsorptionAmount() < healthNewEffectShouldGive && event.getNewEffect().getDuration() < event.getOldEffect().getDuration()) {
                    player.removePotionEffect(PotionEffectType.ABSORPTION);
                    player.addPotionEffect(event.getNewEffect());
                }
            }
        }
    }
}

