/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.game.pregame;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import io.github.greatericontop.greatuhc.game.GameManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PreGameManager {
    private final Random random;
    private final GreatUHCMain plugin;
    private Map<UUID, Kit> playerKits = new HashMap<UUID, Kit>();

    public PreGameManager(GreatUHCMain plugin) {
        this.plugin = plugin;
        this.random = new Random();
    }

    public Kit getPlayerKit(UUID player) {
        return this.playerKits.getOrDefault(player, Kit.ARMORER);
    }

    public void setPlayerKit(UUID player, Kit kit) {
        this.playerKits.put(player, kit);
    }

    public void giveKitTo(Player player, boolean isEnhanced) {
        switch (this.getPlayerKit(player.getUniqueId())) {
            case ARMORER: {
                this.giveArmorerTo(player, isEnhanced);
                break;
            }
            case STONE_GEAR: {
                this.giveStoneGearTo(player, isEnhanced);
                break;
            }
            case ECOLOGIST: {
                this.giveEcologistTo(player, isEnhanced);
                break;
            }
            case ENCHANTER: {
                this.giveEnchanterTo(player, isEnhanced);
                break;
            }
            case ARCHER: {
                this.giveArcherTo(player, isEnhanced);
                break;
            }
            case FIRE_LORD: {
                this.giveFireLordTo(player, isEnhanced);
                break;
            }
            case MONSTER_TRAINER: {
                this.giveMonsterTrainerTo(player, isEnhanced);
                break;
            }
            case FATE: {
                this.giveFateTo(player, isEnhanced);
            }
        }
    }

    private void giveArmorerTo(Player player, boolean isEnhanced) {
        ItemStack leatherHelmet = new ItemStack(Material.LEATHER_HELMET, 1);
        ItemStack leatherChestplate = new ItemStack(Material.LEATHER_CHESTPLATE, 1);
        ItemStack leatherLeggings = new ItemStack(Material.LEATHER_LEGGINGS, 1);
        ItemStack leatherBoots = new ItemStack(Material.LEATHER_BOOTS, 1);
        if (isEnhanced) {
            switch (this.random.nextInt(4)) {
                case 0: {
                    leatherHelmet = new ItemStack(Material.IRON_HELMET, 1);
                    break;
                }
                case 1: {
                    leatherChestplate = new ItemStack(Material.IRON_CHESTPLATE, 1);
                    break;
                }
                case 2: {
                    leatherLeggings = new ItemStack(Material.IRON_LEGGINGS, 1);
                    break;
                }
                case 3: {
                    leatherBoots = new ItemStack(Material.IRON_BOOTS, 1);
                }
            }
        }
        leatherHelmet.addEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
        leatherHelmet.addEnchantment(Enchantment.DURABILITY, 1);
        leatherChestplate.addEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
        leatherChestplate.addEnchantment(Enchantment.DURABILITY, 1);
        leatherLeggings.addEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
        leatherLeggings.addEnchantment(Enchantment.DURABILITY, 1);
        leatherBoots.addEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
        leatherBoots.addEnchantment(Enchantment.DURABILITY, 1);
        player.getInventory().addItem(new ItemStack[]{leatherHelmet, leatherChestplate, leatherLeggings, leatherBoots});
    }

    private void giveStoneGearTo(Player player, boolean isEnhanced) {
        ItemStack sword = new ItemStack(Material.STONE_SWORD);
        ItemStack pick = new ItemStack(Material.STONE_PICKAXE);
        ItemStack axe = new ItemStack(Material.STONE_AXE);
        ItemStack shovel = new ItemStack(Material.STONE_SHOVEL);
        if (isEnhanced) {
            switch (this.random.nextInt(4)) {
                case 0: {
                    sword = new ItemStack(Material.IRON_SWORD);
                    break;
                }
                case 1: {
                    pick = new ItemStack(Material.IRON_PICKAXE);
                    break;
                }
                case 2: {
                    axe = new ItemStack(Material.IRON_AXE);
                    break;
                }
                case 3: {
                    shovel = new ItemStack(Material.IRON_SHOVEL);
                }
            }
        }
        sword.addEnchantment(Enchantment.DURABILITY, 1);
        pick.addEnchantment(Enchantment.DIG_SPEED, 2);
        pick.addEnchantment(Enchantment.DURABILITY, 1);
        axe.addEnchantment(Enchantment.DIG_SPEED, 2);
        axe.addEnchantment(Enchantment.DURABILITY, 1);
        shovel.addEnchantment(Enchantment.DIG_SPEED, 2);
        shovel.addEnchantment(Enchantment.DURABILITY, 1);
        player.getInventory().addItem(new ItemStack[]{sword, pick, axe, shovel});
    }

    private void giveEcologistTo(Player player, boolean isEnhanced) {
        ItemStack lilyPad = new ItemStack(Material.LILY_PAD, 64);
        ItemStack oakLog = new ItemStack(Material.OAK_LOG, 20);
        ItemStack apple = new ItemStack(Material.APPLE, 3);
        ItemStack sugarCane = new ItemStack(Material.SUGAR_CANE, 3);
        ItemStack stonePickaxe = new ItemStack(Material.STONE_PICKAXE);
        stonePickaxe.addEnchantment(Enchantment.DIG_SPEED, 1);
        player.getInventory().addItem(new ItemStack[]{lilyPad, oakLog, apple, sugarCane, stonePickaxe});
        if (isEnhanced) {
            double d = this.random.nextDouble();
            if (d < 0.15) {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.CARROT, 3)});
            } else if (d < 0.425) {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.COW_SPAWN_EGG, 6)});
            } else if (d < 0.7) {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.CHICKEN_SPAWN_EGG, 6)});
            } else {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.COAL_BLOCK, 5)});
            }
        }
    }

    private void giveEnchanterTo(Player player, boolean isEnhanced) {
        ItemStack leather = new ItemStack(Material.LEATHER, 6);
        ItemStack sugarCane = new ItemStack(Material.SUGAR_CANE, 12);
        ItemStack experienceBottle = new ItemStack(Material.EXPERIENCE_BOTTLE, 30);
        ItemStack stonePickaxe = new ItemStack(Material.STONE_PICKAXE);
        stonePickaxe.addEnchantment(Enchantment.DIG_SPEED, 1);
        player.getInventory().addItem(new ItemStack[]{leather, sugarCane, experienceBottle, stonePickaxe});
        if (isEnhanced) {
            switch (this.random.nextInt(3)) {
                case 0: {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.OBSIDIAN, 2)});
                    break;
                }
                case 1: {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BOOK, 4)});
                    break;
                }
                case 2: {
                    ItemStack enchantedBook = new ItemStack(Material.ENCHANTED_BOOK, 1);
                    EnchantmentStorageMeta im = (EnchantmentStorageMeta)enchantedBook.getItemMeta();
                    Enchantment[] enchants = new Enchantment[]{Enchantment.DAMAGE_ALL, Enchantment.KNOCKBACK, Enchantment.SWEEPING_EDGE, Enchantment.PROTECTION_ENVIRONMENTAL, Enchantment.PROTECTION_PROJECTILE, Enchantment.ARROW_DAMAGE, Enchantment.ARROW_KNOCKBACK};
                    im.addStoredEnchant(enchants[this.random.nextInt(enchants.length)], 1, true);
                    enchantedBook.setItemMeta((ItemMeta)im);
                    player.getInventory().addItem(new ItemStack[]{enchantedBook});
                }
            }
        }
    }

    private void giveArcherTo(Player player, boolean isEnhanced) {
        ItemStack string = new ItemStack(Material.STRING, 3);
        ItemStack feather = new ItemStack(Material.FEATHER, 7);
        ItemStack shovel = new ItemStack(Material.STONE_SHOVEL);
        shovel.addEnchantment(Enchantment.DIG_SPEED, 1);
        player.getInventory().addItem(new ItemStack[]{string, feather, shovel});
        if (isEnhanced) {
            switch (this.random.nextInt(3)) {
                case 0: {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.FLINT, 5)});
                    break;
                }
                case 1: {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BONE, 4)});
                    break;
                }
                case 2: {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ARROW, this.random.nextInt(33) + 32)});
                }
            }
        }
    }

    private void giveFireLordTo(Player player, boolean isEnhanced) {
        ItemStack woodSword = new ItemStack(Material.WOODEN_SWORD, 1);
        woodSword.addEnchantment(Enchantment.FIRE_ASPECT, 1);
        ItemStack lava = new ItemStack(Material.LAVA_BUCKET, 1);
        ItemStack flintAndSteel = new ItemStack(Material.FLINT_AND_STEEL, 1);
        player.getInventory().addItem(new ItemStack[]{woodSword, lava, lava, lava, lava, lava, flintAndSteel});
        if (isEnhanced) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BLAZE_ROD, 2)});
        }
    }

    private void giveMonsterTrainerTo(Player player, boolean isEnhanced) {
        ItemStack zombieEgg = new ItemStack(Material.ZOMBIE_SPAWN_EGG, 2);
        ItemStack skeletonEgg = new ItemStack(Material.SKELETON_SPAWN_EGG, 2);
        ItemStack spiderEgg = new ItemStack(Material.SPIDER_SPAWN_EGG, 2);
        ItemStack creeperEgg = new ItemStack(Material.CREEPER_SPAWN_EGG, 2);
        player.getInventory().addItem(new ItemStack[]{zombieEgg, skeletonEgg, spiderEgg, creeperEgg});
        if (isEnhanced) {
            switch (this.random.nextInt(3)) {
                case 0: {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ENDER_PEARL, 1)});
                    break;
                }
                case 1: {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.MAGMA_CREAM, 2)});
                    break;
                }
                case 2: {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.SLIME_BALL, 4)});
                }
            }
        }
    }

    private void giveFateTo(Player player, boolean isEnhanced) {
        if (!this.plugin.uhcFateKit) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.DIRT, 1)});
            player.sendMessage("\u00a7cYou get what you deserve.");
            return;
        }
        ItemStack superXPBottles = new ItemStack(Material.EXPERIENCE_BOTTLE, 32);
        ItemMeta im = superXPBottles.getItemMeta();
        im.setDisplayName("\u00a7eSuper XP Bottle");
        im.setLore(List.of("id: SUPER_XP_BOTTLE"));
        superXPBottles.setItemMeta(im);
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.MOSSY_COBBLESTONE, isEnhanced ? 126 : 63), new ItemStack(Material.JUKEBOX, isEnhanced ? 18 : 9), new ItemStack(Material.PLAYER_HEAD, isEnhanced ? 20 : 11), new ItemStack(Material.GOLD_INGOT, isEnhanced ? 48 : 32), new ItemStack(Material.APPLE, isEnhanced ? 5 : 3), new ItemStack(Material.OAK_PLANKS, 64), new ItemStack(Material.IRON_INGOT, 32), new ItemStack(Material.ANVIL, 1), superXPBottles, new ItemStack(Material.PAPER, isEnhanced ? 24 : 12), new ItemStack(Material.FLINT, isEnhanced ? 4 : 2), new ItemStack(Material.BOW, 1), new ItemStack(Material.ARROW, 48)});
    }

    public static void startPreGame(GameManager gameManager) {
        World overworld = gameManager.getOverworld();
        Bukkit.broadcast((Component)Component.text((String)"\u00a79------------------------------"));
        Bukkit.broadcast((Component)Component.text((String)"\u00a74\u00a7lGreatUHC"));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a7aThe game will start in \u00a7e45 \u00a7aseconds."));
        Bukkit.broadcast((Component)Component.text((String)"\u00a7aChoose a kit and get ready to fight!"));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a79------------------------------"));
        overworld.getWorldBorder().setSize(30.0);
        overworld.getWorldBorder().setCenter(2000.0, 2000.0);
        overworld.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        overworld.setTime(6000L);
        for (int x = 1985; x < 2015; ++x) {
            for (int z = 1985; z < 2015; ++z) {
                overworld.getBlockAt(x, 319, z).setType(Material.AIR);
                overworld.getBlockAt(x, 318, z).setType(Material.BEDROCK);
            }
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.getInventory().clear();
            ItemStack kitSelector = new ItemStack(Material.DIAMOND, 1);
            ItemMeta im = kitSelector.getItemMeta();
            im.setDisplayName("\u00a76Kit Selector");
            im.setLore(List.of("Kit Selector"));
            im.addEnchant(Enchantment.LUCK, 1, true);
            kitSelector.setItemMeta(im);
            ItemStack sword = new ItemStack(Material.NETHERITE_SWORD, 1);
            ItemStack craftingTable = new ItemStack(Material.CRAFTING_TABLE, 1);
            player.getInventory().addItem(new ItemStack[]{kitSelector, sword, craftingTable});
            player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 999999, 4));
            player.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 999999, 0));
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 999999, 4));
            player.setGameMode(GameMode.SURVIVAL);
            player.undiscoverRecipes((Collection)player.getDiscoveredRecipes());
            player.chat("/uhcrecipes");
            player.teleport(new Location(overworld, 2000.0, 320.0, 2000.0));
        }
    }

    public static enum Kit {
        ARMORER,
        STONE_GEAR,
        ECOLOGIST,
        ENCHANTER,
        ARCHER,
        FIRE_LORD,
        MONSTER_TRAINER,
        FATE;

    }
}

