/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.game.pregame;

import io.github.greatericontop.greatuhc.game.pregame.PreGameManager;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KitSelectorGUIListener
implements Listener {
    private static final String INVENTORY_NAME = "\u00a7e\u00a7k~~ \u00a76UHC Kits \u00a7e\u00a7k~~";
    private PreGameManager manager;

    public KitSelectorGUIListener(PreGameManager manager) {
        this.manager = manager;
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack heldItem = event.getPlayer().getInventory().getItemInMainHand();
        ItemMeta im = heldItem.getItemMeta();
        if (im == null) {
            return;
        }
        if (im.getLore() != null && ((String)im.getLore().get(0)).equals("Kit Selector")) {
            this.openKitSelector(event.getPlayer());
        }
    }

    private ItemStack newItemStack(Material mat, String name, String ... lore) {
        ItemStack stack = new ItemStack(mat, 1);
        ItemMeta im = stack.getItemMeta();
        im.setDisplayName(name);
        im.setLore(Arrays.asList(lore));
        stack.setItemMeta(im);
        return stack;
    }

    public void openKitSelector(Player player) {
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)INVENTORY_NAME);
        for (int i = 0; i < 9; ++i) {
            gui.setItem(i, new ItemStack(Material.GRAY_STAINED_GLASS_PANE, 1));
        }
        gui.setItem(0, this.newItemStack(Material.LEATHER_CHESTPLATE, "\u00a7eArmorer", "\u00a77Leather Helmet (protection 1 unbreaking 1)", "\u00a77Leather Chestplate (protection 1 unbreaking 1)", "\u00a77Leather Leggings (protection 1 unbreaking 1)", "\u00a77Leather Boots (protection 1 unbreaking 1)", "", "\u00a76Enhancement", "\u00a77One piece of armor will be upgraded to iron."));
        gui.setItem(1, this.newItemStack(Material.STONE_PICKAXE, "\u00a7eStone Gear", "\u00a77Stone Sword (unbreaking 1)", "\u00a77Stone Pickaxe (efficiency 2 unbreaking 1)", "\u00a77Stone Axe (efficiency 2 unbreaking 1)", "\u00a77Stone Shovel (efficiency 2 unbreaking 1)", "", "\u00a76Enhancement", "\u00a77One tool will be upgraded to iron."));
        gui.setItem(2, this.newItemStack(Material.VINE, "\u00a7eEcologist", "\u00a7764 Lily Pad", "\u00a7720 Oak Log", "\u00a773 Apple", "\u00a773 Sugar Cane", "\u00a77Stone Pickaxe (efficiency 1)", "", "\u00a76Enhancement", "\u00a77Chance to get:", "\u00a77carrots, cow eggs, chicken eggs, coal blocks"));
        gui.setItem(3, this.newItemStack(Material.ENCHANTING_TABLE, "\u00a7eEnchanter", "\u00a776 Leather", "\u00a7712 Sugar Cane", "\u00a7730 Bottle o' Enchanting", "\u00a77Stone Pickaxe (efficiency 1)", "", "\u00a76Enhancement", "\u00a77Chance to get:", "\u00a77obsidian, books, enchanted books"));
        gui.setItem(4, this.newItemStack(Material.BOW, "\u00a7eArcher", "\u00a773 String", "\u00a777 Feather", "\u00a77Stone Shovel (efficiency 1)", "", "\u00a76Enhancement", "\u00a77Chance to get:", "\u00a77flint, bones, arrows"));
        gui.setItem(5, this.newItemStack(Material.LAVA_BUCKET, "\u00a7eFire Lord", "\u00a77Wooden Sword (Fire Aspect)", "\u00a775 Lava Bucket", "\u00a77Flint and Steel", "", "\u00a76Enhancement", "\u00a772 Blaze Rod"));
        gui.setItem(6, this.newItemStack(Material.ZOMBIE_HEAD, "\u00a7eMonster Trainer", "\u00a772 Zombie Spawn Egg", "\u00a772 Skeleton Spawn Egg", "\u00a772 Spider Spawn Egg", "\u00a772 Creeper Spawn Egg", "", "\u00a76Enhancement", "\u00a77Chance to get:", "\u00a77ender pearl, magma cream, slime ball"));
        gui.setItem(8, this.newItemStack(Material.END_PORTAL_FRAME, "\u00a77Fate", "\u00a77This kit could be a blessing or a curse."));
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!event.getView().getTopInventory().equals(event.getClickedInventory())) {
            return;
        }
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.GRAY_STAINED_GLASS_PANE) {
            event.setCancelled(true);
            return;
        }
        switch (event.getSlot()) {
            case 0: {
                this.manager.setPlayerKit(player.getUniqueId(), PreGameManager.Kit.ARMORER);
                break;
            }
            case 1: {
                this.manager.setPlayerKit(player.getUniqueId(), PreGameManager.Kit.STONE_GEAR);
                break;
            }
            case 2: {
                this.manager.setPlayerKit(player.getUniqueId(), PreGameManager.Kit.ECOLOGIST);
                break;
            }
            case 3: {
                this.manager.setPlayerKit(player.getUniqueId(), PreGameManager.Kit.ENCHANTER);
                break;
            }
            case 4: {
                this.manager.setPlayerKit(player.getUniqueId(), PreGameManager.Kit.ARCHER);
                break;
            }
            case 5: {
                this.manager.setPlayerKit(player.getUniqueId(), PreGameManager.Kit.FIRE_LORD);
                break;
            }
            case 6: {
                this.manager.setPlayerKit(player.getUniqueId(), PreGameManager.Kit.MONSTER_TRAINER);
                break;
            }
            case 8: {
                this.manager.setPlayerKit(player.getUniqueId(), PreGameManager.Kit.FATE);
            }
        }
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        event.setCancelled(true);
    }
}

