/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.game;

import io.github.greatericontop.greatuhc.customitems.Crafts;
import io.github.greatericontop.greatuhc.game.GameManager;
import io.github.greatericontop.greatuhc.util.GameUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GracePeriod {
    public static void start(GameManager gameManager) {
        World overworld = gameManager.getOverworld();
        World nether = gameManager.getNether();
        Bukkit.broadcast((Component)Component.text((String)"\u00a79------------------------------"));
        Bukkit.broadcast((Component)Component.text((String)"\u00a74\u00a7lGreatUHC"));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a7aThe grace period has started!"));
        Bukkit.broadcast((Component)Component.text((String)"\u00a7aYou have 15 minutes to gather resources!"));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a79------------------------------"));
        overworld.setGameRule(GameRule.NATURAL_REGENERATION, (Object)false);
        nether.setGameRule(GameRule.NATURAL_REGENERATION, (Object)false);
        overworld.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
        overworld.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
        nether.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
        overworld.getWorldBorder().setSize(gameManager.getPlugin().getConfig().getDouble("overworld_main_border_start"));
        overworld.getWorldBorder().setCenter(0.0, 0.0);
        overworld.getWorldBorder().setDamageAmount(0.0);
        nether.getWorldBorder().setSize(gameManager.getPlugin().getConfig().getDouble("nether_main_border_start"));
        nether.getWorldBorder().setCenter(0.0, 0.0);
        nether.getWorldBorder().setDamageAmount(0.0);
        gameManager.getPlugin().craftLimiter.clearCrafts();
        ItemStack randomUltimate = null;
        if (gameManager.getPlugin().uhcRandomUltimate) {
            randomUltimate = Crafts.getRandomUltimate();
        }
        ItemStack startingHeads = null;
        if (gameManager.getPlugin().uhcStartingHeads) {
            startingHeads = new ItemStack(Material.PLAYER_HEAD, 3);
            SkullMeta im = (SkullMeta)startingHeads.getItemMeta();
            im.setOwningPlayer(Bukkit.getOfflinePlayer((String)"MHF_Villager"));
            im.setDisplayName("\u00a7eStarting Head");
            startingHeads.setItemMeta((ItemMeta)im);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.getInventory().clear();
            player.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(40.0);
            if (gameManager.getPlugin().uhcFastReflexes) {
                player.getAttribute(Attribute.GENERIC_ATTACK_SPEED).setBaseValue(99.0);
            } else {
                player.getAttribute(Attribute.GENERIC_ATTACK_SPEED).setBaseValue(4.0);
            }
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 18000, 0));
            player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 18000, 0));
            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 18000, 0));
            player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 18000, 3));
            player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 200, 4));
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 200, 4));
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 200, 1));
            gameManager.getPreGameManager().giveKitTo(player, gameManager.getPlugin().uhcEnhancedKits);
            if (randomUltimate != null) {
                player.sendMessage("\u00a7bYou have been given a random ultimate!");
                player.getInventory().addItem(new ItemStack[]{randomUltimate});
            }
            if (startingHeads == null) continue;
            player.sendMessage("\u00a7bYou have been given starting heads!");
            player.getInventory().addItem(new ItemStack[]{startingHeads});
        }
        String spreadCommand = String.format("spreadplayers 0 0 %s %s false @a", gameManager.getPlugin().getConfig().getString("main_spread_min"), gameManager.getPlugin().getConfig().getString("main_spread_max"));
        Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)spreadCommand);
        GameUtils.freezePlayers(gameManager.getPlugin(), 200);
    }
}

