/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.game;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import io.github.greatericontop.greatuhc.Placeholders;
import io.github.greatericontop.greatuhc.game.DeathmatchPeriod;
import io.github.greatericontop.greatuhc.game.GracePeriod;
import io.github.greatericontop.greatuhc.game.PVPPeriod;
import io.github.greatericontop.greatuhc.game.pregame.PreGameManager;
import io.github.greatericontop.greatuhc.util.GameUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GameManager {
    private GamePhase currentPhase;
    private int ticksLeft;
    private World overworld;
    private World nether;
    private final GreatUHCMain plugin;
    private final PreGameManager preGameManager;

    public GamePhase getCurrentPhase() {
        return this.currentPhase;
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public World getOverworld() {
        return this.overworld;
    }

    public World getNether() {
        return this.nether;
    }

    public GreatUHCMain getPlugin() {
        return this.plugin;
    }

    public PreGameManager getPreGameManager() {
        return this.preGameManager;
    }

    public GameManager(GreatUHCMain plugin, PreGameManager preGameManager) {
        this.plugin = plugin;
        this.preGameManager = preGameManager;
        this.currentPhase = GamePhase.INACTIVE;
        this.ticksLeft = -1;
        this.overworld = Bukkit.getWorld((String)plugin.getConfig().getString("overworld_name"));
        this.nether = Bukkit.getWorld((String)plugin.getConfig().getString("nether_name"));
    }

    public void registerRunnable() {
        new BukkitRunnable(){

            public void run() {
                Player winner;
                if (GameManager.this.currentPhase == GamePhase.INACTIVE) {
                    return;
                }
                --GameManager.this.ticksLeft;
                if (GameManager.this.ticksLeft <= 0) {
                    switch (GameManager.this.currentPhase) {
                        case PRE_GAME: {
                            GameManager.this.currentPhase = GamePhase.GRACE_PERIOD;
                            GameManager.this.ticksLeft = GameManager.this.plugin.getConfig().getInt("grace_period_time");
                            GracePeriod.start(GameManager.this);
                            break;
                        }
                        case GRACE_PERIOD: {
                            GameManager.this.currentPhase = GamePhase.PVP;
                            GameManager.this.ticksLeft = GameManager.this.plugin.getConfig().getInt("pvp_time");
                            PVPPeriod.start(GameManager.this);
                            break;
                        }
                        case PVP: {
                            GameManager.this.currentPhase = GamePhase.DEATHMATCH;
                            GameManager.this.ticksLeft = GameManager.this.plugin.getConfig().getInt("deathmatch_time");
                            DeathmatchPeriod.start(GameManager.this);
                            break;
                        }
                        case DEATHMATCH: {
                            GameManager.this.currentPhase = GamePhase.INACTIVE;
                            GameManager.this.ticksLeft = 0;
                        }
                    }
                } else if (GameManager.this.ticksLeft % 20 == 0) {
                    int seconds = GameManager.this.ticksLeft / 20;
                    if (seconds == 30 || seconds == 45 || seconds == 60) {
                        for (Object player : Bukkit.getOnlinePlayers()) {
                            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                        }
                        Bukkit.broadcastMessage((String)String.format("\u00a77| \u00a7b%d \u00a76seconds left", seconds));
                    } else if (seconds % 60 == 0) {
                        int minutes = seconds / 60;
                        if (minutes <= 8 || minutes % 5 == 0) {
                            Bukkit.broadcastMessage((String)String.format("\u00a77| \u00a7b%d \u00a7eminutes left", minutes));
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                            }
                        }
                    } else if (seconds <= 20) {
                        for (Object player : Bukkit.getOnlinePlayers()) {
                            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                        }
                        if (seconds <= 10 || seconds == 15 || seconds == 20) {
                            Bukkit.broadcastMessage((String)String.format("\u00a77| \u00a7b%d \u00a7cseconds left", seconds));
                        }
                    }
                }
                if (GameManager.this.currentPhase == GamePhase.PVP && GameManager.this.ticksLeft > GameManager.this.plugin.getConfig().getInt("game_shortener.decrease_to") && Placeholders.getPlayersAliveCount() <= GameManager.this.plugin.getConfig().getInt("game_shortener.players_left")) {
                    Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)GameManager.this.plugin.getConfig().getString("game_shortener.message")));
                    for (Player p1 : Bukkit.getOnlinePlayers()) {
                        p1.playSound(p1.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.0f, 1.0f);
                    }
                    GameManager.this.ticksLeft = GameManager.this.plugin.getConfig().getInt("game_shortener.decrease_to");
                }
                if (GameManager.this.plugin.getConfig().getBoolean("winner_check") && (winner = GameUtils.getWinner()) != null) {
                    winner.showTitle(Title.title((Component)Component.text((String)"\u00a7a\u00a7lYOU WON!"), (Component)Component.text((String)"")));
                    winner.playSound(winner.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
                    GameManager.this.currentPhase = GamePhase.INACTIVE;
                    GameManager.this.ticksLeft = 0;
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    public void start() {
        this.currentPhase = GamePhase.PRE_GAME;
        this.ticksLeft = this.plugin.getConfig().getInt("pre_game_time");
        PreGameManager.startPreGame(this);
    }

    public String getMessageLine1() {
        switch (this.currentPhase) {
            case INACTIVE: {
                return "\u00a77No running game";
            }
            case PRE_GAME: {
                return "\u00a7fGame Starts in";
            }
            case GRACE_PERIOD: {
                return "\u00a7fPVP Enables in";
            }
            case PVP: {
                return "\u00a7fDeathmatch in";
            }
            case DEATHMATCH: {
                return "\u00a7fGame End in";
            }
        }
        return "\u00a7cInactive";
    }

    public String getMessageLine2() {
        if (this.currentPhase == GamePhase.INACTIVE) {
            return "\u00a77-----";
        }
        int seconds = (this.ticksLeft + 19) / 20;
        if (seconds <= 60) {
            return String.format("\u00a7%s%d seconds", seconds >= 30 || seconds % 2 == 0 ? "a" : "c", seconds);
        }
        return String.format("\u00a7a%d minutes", (seconds + 30) / 60);
    }

    public void extend(int seconds) {
        this.ticksLeft += seconds * 20;
    }

    public static enum GamePhase {
        INACTIVE,
        PRE_GAME,
        GRACE_PERIOD,
        PVP,
        DEATHMATCH;

    }
}

