/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.game;

import io.github.greatericontop.greatuhc.game.GameManager;
import io.github.greatericontop.greatuhc.util.GameUtils;
import io.github.greatericontop.greatuhc.util.OpenSimplex2;
import java.util.Random;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class DeathmatchPeriod {
    private static final int[] dx = new int[]{2, -2, 0, 0};
    private static final int[] dz = new int[]{0, 0, 2, -2};
    private static final double ANGLE_CONVERSION = 0.19634954084936207;
    private static final BlockFace[] faces = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH};
    private static final Material[] stoneTopMaterials = new Material[]{Material.STONE, Material.STONE, Material.STONE, Material.STONE, Material.STONE, Material.MOSSY_COBBLESTONE, Material.COBBLESTONE, Material.COBBLESTONE, Material.COBBLESTONE, Material.STONE_BRICKS};
    private static final Material[] sandTopMaterials = new Material[]{Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, Material.SAND, Material.SAND, Material.SAND, Material.SAND, Material.SAND, Material.RED_SAND, Material.RED_SANDSTONE};
    private static final int XZ_OFFSET = 2000;
    private static final int MAX_WORLD_HEIGHT = 319;

    public static void start(GameManager gameManager) {
        final World overworld = gameManager.getOverworld();
        Random random = new Random();
        final FileConfiguration config = gameManager.getPlugin().getConfig();
        Bukkit.broadcast((Component)Component.text((String)"\u00a79------------------------------"));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a7bDeathmatch has started!"));
        Bukkit.broadcast((Component)Component.text((String)"\u00a7eFight to the death!"));
        Bukkit.broadcast((Component)Component.text((String)"\u00a77The game will end in 15 minutes."));
        Bukkit.broadcast((Component)Component.text((String)"\u00a77You'll be able to move in 10 seconds."));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a79------------------------------"));
        overworld.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
        overworld.getWorldBorder().setCenter(2000.0, 2000.0);
        overworld.getWorldBorder().setSize(config.getDouble("deathmatch_border_start"));
        new BukkitRunnable(){

            public void run() {
                overworld.getWorldBorder().setSize(config.getDouble("deathmatch_border_end"), config.getLong("deathmatch_border_shrink_time"));
            }
        }.runTaskLater((Plugin)gameManager.getPlugin(), config.getLong("deathmatch_border_shrink_after"));
        int RADIUS = config.getInt("deathmatch_gen.radius");
        double XZ_SCALE = config.getDouble("deathmatch_gen.xz_noise_scale");
        int EXTRA_DISTANCE_THRESHOLD = config.getInt("deathmatch_gen.extra_distance_threshold");
        double BLOCK_SEL_SCALE = config.getDouble("deathmatch_gen.block_selection_noise_scale");
        double DIAMOND_CHANCE = config.getDouble("deathmatch_gen.diamond_chance");
        int DEATHMATCH_WORLD_HEIGHT = config.getInt("deathmatch_gen.deathmatch_world_height");
        int PYRAMID_HEIGHT = config.getInt("deathmatch_gen.pyramid_height");
        int TERRAIN_HEIGHT = config.getInt("deathmatch_gen.terrain_height");
        double EXTRA_A = config.getDouble("deathmatch_gen.extra_a");
        double EXTRA_B = config.getDouble("deathmatch_gen.extra_b");
        double EXTRA_DISTANCE_SCALE = RADIUS - EXTRA_DISTANCE_THRESHOLD;
        long seedTerrain = random.nextLong();
        long seedTop = random.nextLong();
        for (int x = -RADIUS; x <= RADIUS; ++x) {
            for (int z = -RADIUS; z <= RADIUS; ++z) {
                double noise = (double)OpenSimplex2.noise2(seedTerrain, (double)x / XZ_SCALE, (double)z / XZ_SCALE) * 0.5 + 0.5;
                int extraDistance = Math.max(Math.abs(x), Math.abs(z)) - EXTRA_DISTANCE_THRESHOLD;
                if (extraDistance > 0) {
                    double distMul = (double)extraDistance / EXTRA_DISTANCE_SCALE;
                    noise += EXTRA_A * Math.pow(distMul, 1.4) + EXTRA_B * distMul;
                }
                int height = (int)((double)TERRAIN_HEIGHT * noise) + 1;
                for (int y = 0; y <= 319 - DEATHMATCH_WORLD_HEIGHT; ++y) {
                    double noiseTop;
                    Material mat = y == height ? ((noiseTop = (double)OpenSimplex2.noise2(seedTop, (double)x / BLOCK_SEL_SCALE, (double)z / BLOCK_SEL_SCALE) * 0.5 + 0.5) < 0.4 || Math.random() < 0.5 && noiseTop < 0.5 ? stoneTopMaterials[random.nextInt(stoneTopMaterials.length)] : (noiseTop < 0.75 || Math.random() < 0.5 && noiseTop < 0.85 ? Material.GRASS_BLOCK : sandTopMaterials[random.nextInt(sandTopMaterials.length)])) : (y <= height ? Material.BEDROCK : Material.AIR);
                    overworld.getBlockAt(x + 2000, y + DEATHMATCH_WORLD_HEIGHT, z + 2000).setType(mat, false);
                }
            }
        }
        int eligibleAmountPlaced = 0;
        int debugAmountDiamond = 0;
        for (int x = -PYRAMID_HEIGHT + 1; x <= PYRAMID_HEIGHT - 1; ++x) {
            for (int z = -PYRAMID_HEIGHT + 1; z <= PYRAMID_HEIGHT - 1; ++z) {
                int yMax = PYRAMID_HEIGHT - Math.max(Math.abs(x), Math.abs(z));
                for (int deltaY = 1; deltaY <= yMax; ++deltaY) {
                    Block block = overworld.getBlockAt(x + 2000, DEATHMATCH_WORLD_HEIGHT + deltaY, z + 2000);
                    if (block.getType() == Material.BEDROCK) continue;
                    boolean isOre = deltaY != yMax && random.nextDouble() < DIAMOND_CHANCE;
                    block.setType(isOre ? Material.DIAMOND_ORE : Material.SMOOTH_SANDSTONE, false);
                    debugAmountDiamond += isOre ? 1 : 0;
                    eligibleAmountPlaced += deltaY != yMax ? 1 : 0;
                }
            }
        }
        int chestWithGoldApple = random.nextInt(4);
        for (int chestNum = 0; chestNum < 4; ++chestNum) {
            Block chestBlock = overworld.getBlockAt(dx[chestNum] + 2000, DEATHMATCH_WORLD_HEIGHT + PYRAMID_HEIGHT - 1, dz[chestNum] + 2000);
            chestBlock.setType(Material.CHEST, false);
            org.bukkit.block.Chest chest = (org.bukkit.block.Chest)chestBlock.getState();
            Chest chestData = (Chest)chestBlock.getBlockData();
            chestData.setFacing(faces[chestNum]);
            chestBlock.setBlockData((BlockData)chestData);
            Inventory inv = chest.getInventory();
            int[] chestItems = GameUtils.shuffleChest(random);
            if (chestNum == chestWithGoldApple) {
                inv.setItem(chestItems[0], new ItemStack(Material.GOLDEN_APPLE, 1));
            }
            inv.setItem(chestItems[1], new ItemStack(Material.APPLE, 1));
            inv.setItem(chestItems[2], new ItemStack(Material.OAK_LOG, 8));
            inv.setItem(chestItems[3], new ItemStack(Material.COAL, 1));
            inv.setItem(chestItems[4], new ItemStack(Material.STICK, 1));
            inv.setItem(chestItems[5], new ItemStack(Material.ARROW, 12));
            inv.setItem(chestItems[6], new ItemStack(Material.ARROW, 12));
        }
        double SPREAD_RADIUS = config.getDouble("deathmatch_spread_radius");
        if (Bukkit.getOnlinePlayers().size() > 32) {
            Bukkit.broadcastMessage((String)"\u00a7cToo many players! Falling back to normal spread algorithm.");
            String spreadCommand = String.format("spreadplayers %d %d %s %s false @a", 2000, 2000, 8, (int)SPREAD_RADIUS);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)spreadCommand);
        } else {
            int[] positions = GameUtils.shufflePositions(random);
            int i = 0;
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 200, 4));
                int x = (int)Math.round(SPREAD_RADIUS * Math.cos((double)positions[i] * 0.19634954084936207));
                int z = (int)Math.round(SPREAD_RADIUS * Math.sin((double)positions[i] * 0.19634954084936207));
                Location top = new Location(overworld, (double)(x + 2000), (double)overworld.getHighestBlockYAt(x + 2000, z + 2000), (double)(z + 2000));
                top.getBlock().setType(Material.QUARTZ_BLOCK);
                player.teleport(top.add(0.5, 1.0, 0.5));
                ++i;
            }
        }
        GameUtils.freezePlayers(gameManager.getPlugin(), 200);
    }
}

