/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.customitems;

import io.github.greatericontop.greatuhc.game.GameManager;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class PeriodicItemUpgradeListener
implements Listener {
    private GameManager gameManager;

    public PeriodicItemUpgradeListener(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onAnyInteract(PlayerInteractEvent event) {
        int previousLevel;
        ItemStack mainHandItem = event.getPlayer().getInventory().getItemInMainHand();
        ItemMeta im = mainHandItem.getItemMeta();
        if (im == null) {
            return;
        }
        int pvpTime = this.gameManager.getPlugin().getConfig().getInt("pvp_time");
        if (im.getPersistentDataContainer().has(new NamespacedKey("uhc", "apprentice_sword"), PersistentDataType.INTEGER)) {
            previousLevel = im.getEnchantLevel(Enchantment.DAMAGE_ALL);
            im.removeEnchant(Enchantment.DAMAGE_ALL);
            if (this.gameManager.getCurrentPhase() == GameManager.GamePhase.DEATHMATCH) {
                im.addEnchant(Enchantment.DAMAGE_ALL, 3, true);
                if (previousLevel != 3) {
                    event.getPlayer().sendMessage("\u00a7aYour \u00a7cApprentice Sword \u00a7areceived Sharpness III");
                }
            } else if (this.gameManager.getCurrentPhase() == GameManager.GamePhase.PVP && this.gameManager.getTicksLeft() < pvpTime - 12000) {
                im.addEnchant(Enchantment.DAMAGE_ALL, 2, true);
                if (previousLevel != 2) {
                    event.getPlayer().sendMessage("\u00a7aYour \u00a7cApprentice Sword \u00a7areceived Sharpness II");
                }
            } else if (this.gameManager.getCurrentPhase() == GameManager.GamePhase.PVP) {
                im.addEnchant(Enchantment.DAMAGE_ALL, 1, true);
                if (previousLevel != 1) {
                    event.getPlayer().sendMessage("\u00a7aYour \u00a7cApprentice Sword \u00a7areceived Sharpness I");
                }
            }
            mainHandItem.setItemMeta(im);
        }
        if (im.getPersistentDataContainer().has(new NamespacedKey("uhc", "apprentice_bow"), PersistentDataType.INTEGER)) {
            previousLevel = im.getEnchantLevel(Enchantment.ARROW_DAMAGE);
            im.removeEnchant(Enchantment.ARROW_DAMAGE);
            if (this.gameManager.getCurrentPhase() == GameManager.GamePhase.DEATHMATCH) {
                im.addEnchant(Enchantment.ARROW_DAMAGE, 2, true);
                if (previousLevel != 2) {
                    event.getPlayer().sendMessage("\u00a7aYour \u00a7cApprentice Bow \u00a7areceived Power II");
                }
            } else if (this.gameManager.getCurrentPhase() == GameManager.GamePhase.PVP && this.gameManager.getTicksLeft() < pvpTime - 12000) {
                im.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
                if (previousLevel != 1) {
                    event.getPlayer().sendMessage("\u00a7aYour \u00a7cApprentice Bow \u00a7areceived Power I");
                }
            }
            mainHandItem.setItemMeta(im);
        }
    }
}

