/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.customitems;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class ItemVitalityListener
implements Listener {
    private static final double MAX_EUCLIDEAN_DISTANCE_2 = 16.0;
    private Map<UUID, UUID> owners = new HashMap<UUID, UUID>();

    @EventHandler
    public void onPotionThrow(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof ThrownPotion)) {
            return;
        }
        ThrownPotion thrownPotion = (ThrownPotion)projectile;
        ProjectileSource projectileSource = thrownPotion.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        PotionMeta potIM = (PotionMeta)thrownPotion.getItem().getItemMeta();
        if (potIM == null) {
            return;
        }
        if (potIM.getLore() == null) {
            return;
        }
        if (!((String)potIM.getLore().get(0)).equals("Vital")) {
            return;
        }
        this.owners.put(thrownPotion.getUniqueId(), player.getUniqueId());
    }

    @EventHandler
    public void onThrownPotionLand(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof ThrownPotion)) {
            return;
        }
        ThrownPotion thrownPotion = (ThrownPotion)projectile;
        UUID potionOwnerUUID = this.owners.get(thrownPotion.getUniqueId());
        if (potionOwnerUUID == null) {
            return;
        }
        thrownPotion.getWorld().spawnParticle(Particle.SQUID_INK, thrownPotion.getLocation(), 40, 0.0, 0.0, 0.0, 0.08);
        for (Entity entity0 : thrownPotion.getNearbyEntities(4.0, 4.0, 4.0)) {
            LivingEntity entity;
            double distanceSquared;
            if (!(entity0 instanceof LivingEntity) || !((distanceSquared = (entity = (LivingEntity)entity0).getEyeLocation().distanceSquared(thrownPotion.getLocation())) <= 16.0)) continue;
            if (entity.getUniqueId().equals(potionOwnerUUID)) {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 300, 0));
                entity.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 240, 0));
                continue;
            }
            entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 300, 0));
            entity.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 240, 0));
        }
        this.owners.remove(thrownPotion.getUniqueId());
    }
}

