/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.customitems;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemBloodlustListener
implements Listener {
    private static final NamespacedKey BLOODLUST_DAMAGE = new NamespacedKey("uhc", "bloodlust_damage");
    private final Map<UUID, Double> bloodlustInvincibilityFrameMap = new HashMap<UUID, Double>();
    private final GreatUHCMain plugin;

    public ItemBloodlustListener(GreatUHCMain plugin) {
        this.plugin = plugin;
    }

    private void doBloodlust(Player player, double damage) {
        ItemMeta im = player.getInventory().getItemInMainHand().getItemMeta();
        if (im == null) {
            return;
        }
        if (im.getPersistentDataContainer().has(BLOODLUST_DAMAGE, PersistentDataType.DOUBLE)) {
            double iFrameDamage = this.bloodlustInvincibilityFrameMap.getOrDefault(player.getUniqueId(), 0.0);
            double adjustedDamage = damage;
            if (iFrameDamage > 0.0) {
                adjustedDamage = Math.max(0.0, damage - iFrameDamage);
                if (adjustedDamage <= 0.1) {
                    return;
                }
            } else {
                this.bloodlustInvincibilityFrameMap.put(player.getUniqueId(), damage);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.bloodlustInvincibilityFrameMap.remove(player.getUniqueId()), 10L);
            }
            double newTotal = (Double)im.getPersistentDataContainer().get(BLOODLUST_DAMAGE, PersistentDataType.DOUBLE) + adjustedDamage;
            player.sendMessage("\u00a77newTotal  " + newTotal);
            im.getPersistentDataContainer().set(BLOODLUST_DAMAGE, PersistentDataType.DOUBLE, (Object)newTotal);
            int necessarySharpnessLevel = newTotal >= 800.0 ? 4 : (newTotal >= 450.0 ? 3 : (newTotal >= 250.0 ? 2 : (newTotal >= 100.0 ? 1 : 0)));
            if (im.getEnchantLevel(Enchantment.DAMAGE_ALL) != necessarySharpnessLevel) {
                im.removeEnchant(Enchantment.DAMAGE_ALL);
                im.addEnchant(Enchantment.DAMAGE_ALL, necessarySharpnessLevel, false);
                player.sendMessage("\u00a7aYour \u00a7cBloodlust \u00a7awas upgraded!");
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            }
            player.getInventory().getItemInMainHand().setItemMeta(im);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamageByEntityPlayer(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            this.doBloodlust(attacker, event.getDamage());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDamageByEntityProjectile(EntityDamageByEntityEvent event) {
        Projectile projectile;
        Entity entity = event.getDamager();
        if (entity instanceof Projectile && (entity = (projectile = (Projectile)entity).getShooter()) instanceof Player) {
            Player shooter = (Player)entity;
            this.doBloodlust(shooter, event.getDamage());
        }
    }
}

