/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.customitems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class CraftNotifications
implements Listener {
    private static final String HOVER_MSG = "\u00a7eThis is a custom craft in UHC.\n\u00a77Open a crafting table to make this item.\nYou can find the recipe using the knowledge\nbook (in green, on the left).";
    private final List<ShapedRecipe> shapedRecipes = new ArrayList<ShapedRecipe>();
    private final List<ShapelessRecipe> shapelessRecipes = new ArrayList<ShapelessRecipe>();

    public void initializeCraftLists() {
        Bukkit.recipeIterator().forEachRemaining(recipe -> {
            ShapelessRecipe shapelessRecipe;
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                if (shapedRecipe.getKey().getNamespace().equals("uhc")) {
                    this.shapedRecipes.add(shapedRecipe);
                }
            } else if (recipe instanceof ShapelessRecipe && (shapelessRecipe = (ShapelessRecipe)recipe).getKey().getNamespace().equals("uhc")) {
                this.shapelessRecipes.add(shapelessRecipe);
            }
        });
    }

    private boolean _shouldCraft(Map<Material, Integer> inventory, Map<Material, Integer> requiredItems, Material materialPickedUp, int amountPickedUp) {
        for (Map.Entry<Material, Integer> entry : requiredItems.entrySet()) {
            if (entry.getKey() == materialPickedUp) {
                int amountRequired = entry.getValue();
                int beforeAmount = inventory.getOrDefault(entry.getKey(), 0);
                int afterAmount = beforeAmount + amountPickedUp;
                if (beforeAmount < amountRequired && amountRequired <= afterAmount) continue;
                return false;
            }
            if (inventory.getOrDefault(entry.getKey(), 0) >= entry.getValue()) continue;
            return false;
        }
        return requiredItems.containsKey(materialPickedUp);
    }

    private boolean shouldCraft(Map<Material, Integer> inventory, ShapedRecipe recipe, Material materialPickedUp, int amountPickedUp) {
        HashMap<Material, Integer> requiredItems = new HashMap<Material, Integer>();
        for (ItemStack stack : recipe.getIngredientMap().values()) {
            if (stack == null) continue;
            Material mat = stack.getType();
            requiredItems.put(mat, requiredItems.getOrDefault(mat, 0) + 1);
        }
        return this._shouldCraft(inventory, requiredItems, materialPickedUp, amountPickedUp);
    }

    private boolean shouldCraft(Map<Material, Integer> inventory, ShapelessRecipe recipe, Material materialPickedUp, int amountPickedUp) {
        HashMap<Material, Integer> requiredItems = new HashMap<Material, Integer>();
        for (ItemStack stack : recipe.getIngredientList()) {
            Material mat = stack.getType();
            requiredItems.put(mat, requiredItems.getOrDefault(mat, 0) + 1);
        }
        return this._shouldCraft(inventory, requiredItems, materialPickedUp, amountPickedUp);
    }

    private Map<Material, Integer> generateInventoryMap(PlayerInventory inventory) {
        HashMap<Material, Integer> invMap = new HashMap<Material, Integer>();
        for (ItemStack stack : inventory.getContents()) {
            if (stack == null) continue;
            Material mat = stack.getType();
            invMap.put(mat, invMap.getOrDefault(mat, 0) + stack.getAmount());
        }
        return invMap;
    }

    @EventHandler
    public void onPlayerPickupItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        PlayerInventory inventory = player.getInventory();
        ItemStack itemPickedUp = event.getItem().getItemStack();
        Material materialPickedUp = itemPickedUp.getType();
        int amountPickedUp = itemPickedUp.getAmount();
        Map<Material, Integer> invMap = this.generateInventoryMap(inventory);
        for (ShapedRecipe shapedRecipe : this.shapedRecipes) {
            if (!this.shouldCraft(invMap, shapedRecipe, materialPickedUp, amountPickedUp)) continue;
            player.sendMessage(((TextComponent)Component.text((String)"\u00a72[info] \u00a77You have the ingredients to craft ").append(shapedRecipe.getResult().displayName())).append((Component)Component.text((String)"\u00a77.")));
            player.sendMessage(Component.text((String)"      \u00a78(Hover for more)").hoverEvent((HoverEventSource)Component.text((String)HOVER_MSG)));
        }
        for (ShapelessRecipe shapelessRecipe : this.shapelessRecipes) {
            if (!this.shouldCraft(invMap, shapelessRecipe, materialPickedUp, amountPickedUp)) continue;
            player.sendMessage(((TextComponent)Component.text((String)"\u00a72[info] \u00a77You have the ingredients to craft ").append(shapelessRecipe.getResult().displayName())).append((Component)Component.text((String)"\u00a77.")));
            player.sendMessage(Component.text((String)"      \u00a78(Hover for more)").hoverEvent((HoverEventSource)Component.text((String)HOVER_MSG)));
        }
    }
}

